/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.Arrays;

public class DERApplicationSpecific
extends ASN1Object {
    private boolean isConstructed;
    private int tag;
    private byte[] octets;

    DERApplicationSpecific(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, byte[] byArray) {
        this(false, n, byArray);
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this(true, n, dEREncodable);
    }

    public DERApplicationSpecific(boolean bl, int n, DEREncodable dEREncodable) throws IOException {
        if (n >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = dEREncodable.getDERObject().getDEREncoded();
        this.isConstructed = bl;
        this.tag = n;
        if (bl) {
            this.octets = byArray;
        } else {
            int n2 = this.getLengthOfLength(byArray);
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    private int getLengthOfLength(byte[] byArray) {
        int n = 2;
        while ((byArray[n - 1] & 0x80) != 0) {
            ++n;
        }
        return n;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int n) throws IOException {
        if (this.tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byArray[0] = (byte)n;
        return new ASN1InputStream(byArray).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        int n = 64;
        if (this.isConstructed) {
            n |= 0x20;
        }
        dEROutputStream.writeEncoded(n, this.tag, this.octets);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        return this.isConstructed == dERApplicationSpecific.isConstructed && this.tag == dERApplicationSpecific.tag && Arrays.areEqual(this.octets, dERApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }
}

