/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.crypto.MyRandom;
import anon.tor.CellQueue;
import anon.tor.FirstOnionRouterConnection;
import anon.tor.OnionRouter;
import anon.tor.TorChannel;
import anon.tor.cells.Cell;
import anon.tor.cells.CreatedCell;
import anon.tor.cells.DestroyCell;
import anon.tor.cells.PaddingCell;
import anon.tor.cells.RelayCell;
import anon.tor.ordescription.ORDescriptor;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class Circuit
implements Runnable {
    public static final int MAX_STREAMS_OVER_CIRCUIT = 1000;
    private OnionRouter m_FirstOR;
    private ORDescriptor m_lastORDescription;
    private FirstOnionRouterConnection m_FirstORConnection;
    private Vector m_onionRouters;
    private int m_circID;
    private Hashtable m_streams;
    private volatile int m_State;
    private volatile int m_iRelayErrors;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_SHUTDOWN = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_CREATING = 3;
    private int m_streamCounter;
    private int m_circuitLength;
    private int m_MaxStreamsPerCircuit;
    private volatile int m_recvCellCounter;
    private volatile int m_sendCellCounter;
    private boolean m_destroyed;
    private byte[] m_resolvedData;
    private Object m_oResolveSync = new Object();
    private Object m_oSendCellCounterSync = new Object();
    private Object m_oSendSync = new Object();
    private Object m_oDestroyedByPeerSync = new Object();
    private volatile boolean m_bReceivedCreatedOrExtendedCell;
    private Object m_oNotifySync = new Object();
    private MyRandom m_rand;
    private Thread m_threadSendCellLoop;
    private CellQueue m_cellqueueSend;

    public Circuit(int circID, FirstOnionRouterConnection onionProxy, Vector orList) throws IOException {
        this.m_FirstORConnection = onionProxy;
        this.m_circID = circID;
        this.m_streams = new Hashtable();
        this.m_streamCounter = 0;
        this.m_MaxStreamsPerCircuit = 1000;
        this.m_onionRouters = (Vector)orList.clone();
        this.m_circuitLength = orList.size();
        this.m_lastORDescription = (ORDescriptor)this.m_onionRouters.elementAt(this.m_circuitLength - 1);
        if (this.m_onionRouters.size() < 1) {
            throw new IOException("No Onionrouters defined for this circuit");
        }
        this.m_recvCellCounter = 1000;
        this.m_sendCellCounter = 1000;
        this.m_rand = new MyRandom(new SecureRandom());
        this.m_State = 3;
        this.m_destroyed = false;
        this.m_iRelayErrors = 0;
        this.m_cellqueueSend = new CellQueue();
        this.m_threadSendCellLoop = new Thread((Runnable)this, "Tor - Circuit - SendCellLoop");
        this.m_threadSendCellLoop.setDaemon(true);
        this.m_threadSendCellLoop.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSendCellCounter(int value) {
        Object object = this.m_oSendCellCounterSync;
        synchronized (object) {
            this.m_sendCellCounter += value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() throws IOException {
        LogHolder.log(7, LogType.TOR, "[TOR] Creating Circuit '" + this.m_circID + "'");
        this.m_FirstOR = new OnionRouter(this.m_circID, (ORDescriptor)this.m_onionRouters.elementAt(0));
        try {
            Object object = this.m_oNotifySync;
            synchronized (object) {
                this.m_bReceivedCreatedOrExtendedCell = false;
                this.m_FirstORConnection.send(this.m_FirstOR.createConnection());
                this.m_oNotifySync.wait(15000L);
            }
            if (this.m_State != 3 || !this.m_bReceivedCreatedOrExtendedCell) {
                throw new IOException("Error during Circuit creation");
            }
            LogHolder.log(7, LogType.TOR, "[TOR] created!");
            for (int i = 1; i < this.m_onionRouters.size(); ++i) {
                ORDescriptor nextOR = (ORDescriptor)this.m_onionRouters.elementAt(i);
                LogHolder.log(7, LogType.TOR, "[TOR] trying to extend!");
                Object object2 = this.m_oNotifySync;
                synchronized (object2) {
                    this.m_bReceivedCreatedOrExtendedCell = false;
                    RelayCell cell = this.m_FirstOR.extendConnection(nextOR);
                    this.m_FirstORConnection.send(cell);
                    this.m_oNotifySync.wait(25000L);
                }
                if (this.m_State != 3 || !this.m_bReceivedCreatedOrExtendedCell) {
                    throw new IOException("Error during Circuit creation");
                }
                LogHolder.log(7, LogType.TOR, "[TOR] extended!");
            }
            this.m_State = 2;
            LogHolder.log(7, LogType.MISC, "[TOR] Circuit '" + this.m_circID + "' ready!!! - Length of this Circuit : " + this.m_circuitLength + " Onionrouters");
        }
        catch (Exception ex) {
            try {
                if (!this.m_destroyed) {
                    this.send(new DestroyCell(this.m_circID));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_State = 0;
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public synchronized void shutdown() {
        if (this.m_State == 0 || this.m_State == 1) {
            return;
        }
        if (this.m_streams.isEmpty()) {
            this.close();
        }
        this.m_State = 1;
    }

    public synchronized void close() {
        if (this.m_State == 0) {
            return;
        }
        try {
            Enumeration enumer = this.m_streams.elements();
            while (enumer.hasMoreElements()) {
                try {
                    TorChannel c = (TorChannel)enumer.nextElement();
                    c.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_streams.clear();
        try {
            this.m_FirstORConnection.send(new DestroyCell(this.m_circID));
            LogHolder.log(7, LogType.TOR, "[TOR] circuit " + this.m_circID + " destroyed!");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_State = 0;
        try {
            this.m_threadSendCellLoop.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_FirstORConnection.notifyCircuitClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyedByPeer() {
        Object object = this.m_oDestroyedByPeerSync;
        synchronized (object) {
            try {
                Enumeration enumer = this.m_streams.elements();
                while (enumer.hasMoreElements()) {
                    try {
                        TorChannel c = (TorChannel)enumer.nextElement();
                        c.closedByPeer();
                    }
                    catch (Exception exception) {}
                }
                this.m_streams.clear();
                this.m_FirstORConnection.notifyCircuitClosed(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_State = 0;
        }
        object = this.m_oNotifySync;
        synchronized (object) {
            this.m_oNotifySync.notify();
        }
    }

    public boolean isClosed() {
        return this.m_State == 0;
    }

    public boolean isShutdown() {
        return this.m_State == 1 || this.m_State == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchCell(Cell cell) throws IOException {
        block30: {
            try {
                if (cell instanceof RelayCell) {
                    if (this.m_State == 3) {
                        if (!this.m_FirstOR.checkExtendedCell((RelayCell)cell)) {
                            this.send(new DestroyCell(this.m_circID));
                            this.m_State = 0;
                            this.destroyedByPeer();
                            this.m_destroyed = true;
                            break block30;
                        }
                        Object object = this.m_oNotifySync;
                        synchronized (object) {
                            this.m_bReceivedCreatedOrExtendedCell = true;
                            this.m_oNotifySync.notify();
                            break block30;
                        }
                    }
                    --this.m_recvCellCounter;
                    if (this.m_recvCellCounter < 900) {
                        RelayCell rc = new RelayCell(this.m_circID, 5, 0, null);
                        this.send(rc);
                        this.m_recvCellCounter += 100;
                    }
                    RelayCell c = this.m_FirstOR.decryptCell((RelayCell)cell);
                    Integer streamID = c.getStreamID();
                    if (c.getStreamID() == 0) {
                        switch (c.getRelayCommand()) {
                            case 5: {
                                this.addToSendCellCounter(100);
                                break;
                            }
                            default: {
                                LogHolder.log(7, LogType.TOR, "Upps...");
                                break;
                            }
                        }
                        break block30;
                    }
                    if (this.m_streams.containsKey(streamID)) {
                        if (c.getRelayCommand() == 12) {
                            byte[] tmp = c.getPayload();
                            this.m_resolvedData = ByteArrayUtil.copy(tmp, 11, ((tmp[9] & 0xFF) << 8) + (tmp[10] & 0xFF));
                            Object object = this.m_oNotifySync;
                            synchronized (object) {
                                this.m_oNotifySync.notify();
                                break block30;
                            }
                        }
                        TorChannel channel = (TorChannel)this.m_streams.get(streamID);
                        if (channel != null) {
                            if (channel.dispatchCell(c) != 0) {
                                ++this.m_iRelayErrors;
                                if (this.m_iRelayErrors > 10) {
                                    this.shutdown();
                                }
                            }
                        } else {
                            LogHolder.log(7, LogType.TOR, "Upps...");
                        }
                        break block30;
                    }
                    LogHolder.log(7, LogType.TOR, "Upps...Unknown stream");
                    break block30;
                }
                if (cell instanceof CreatedCell) {
                    if (!this.m_FirstOR.checkCreatedCell(cell)) {
                        LogHolder.log(7, LogType.TOR, "[TOR] Should never be here - 'created' cell was wrong");
                        this.m_State = 0;
                        this.destroyedByPeer();
                        break block30;
                    }
                    LogHolder.log(7, LogType.TOR, "[TOR] Connected to the first OR");
                    Object c = this.m_oNotifySync;
                    synchronized (c) {
                        this.m_bReceivedCreatedOrExtendedCell = true;
                        this.m_oNotifySync.notify();
                        break block30;
                    }
                }
                if (!(cell instanceof PaddingCell)) {
                    if (cell instanceof DestroyCell) {
                        byte reason = cell.getPayload()[0];
                        LogHolder.log(7, LogType.TOR, "[TOR] recieved destroycell - circuit destroyed - reason: " + Integer.toString(reason));
                        this.m_destroyed = true;
                        this.destroyedByPeer();
                    } else {
                        LogHolder.log(7, LogType.MISC, "tor kein bekannter cell type");
                    }
                }
            }
            catch (Exception ex) {
                this.destroyedByPeer();
                throw new IOException("Unable to dispatch the cell \n" + ex.getLocalizedMessage());
            }
        }
    }

    public void send(Cell cell) throws IOException, Exception {
        if (this.m_State == 0) {
            throw new IOException("circuit alread closed");
        }
        this.m_cellqueueSend.addElement(cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUrgent(Cell cell) throws IOException, Exception {
        if (this.m_State == 0) {
            throw new IOException("circuit alread closed");
        }
        Object object = this.m_oSendSync;
        synchronized (object) {
            if (cell instanceof RelayCell) {
                cell = this.m_FirstOR.encryptCell((RelayCell)cell);
                this.addToSendCellCounter(-1);
            }
            this.m_FirstORConnection.send(cell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveDNS(String name) {
        if (this.m_State != 2) {
            return null;
        }
        Object object = this.m_oResolveSync;
        synchronized (object) {
            Integer resolveStreamID;
            Hashtable hashtable = this.m_streams;
            synchronized (hashtable) {
                while (this.m_streams.containsKey(resolveStreamID = new Integer(this.m_rand.nextInt(65535)))) {
                }
                this.m_streams.put(resolveStreamID, resolveStreamID);
            }
            RelayCell cell = new RelayCell(this.getCircID(), 11, resolveStreamID, name.getBytes());
            Object object2 = this.m_oNotifySync;
            synchronized (object2) {
                try {
                    this.m_resolvedData = null;
                    this.send(cell);
                    this.m_oNotifySync.wait(20000L);
                }
                catch (Exception ex) {
                    this.m_streams.remove(resolveStreamID);
                    return null;
                }
            }
            this.m_streams.remove(resolveStreamID);
            if (this.m_State == 0 || this.m_resolvedData == null || this.m_resolvedData[0] != 4 || this.m_resolvedData[1] != 4) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(Integer.toString(this.m_resolvedData[2] & 0xFF));
            sb.append('.');
            sb.append(Integer.toString(this.m_resolvedData[3] & 0xFF));
            sb.append('.');
            sb.append(Integer.toString(this.m_resolvedData[4] & 0xFF));
            sb.append('.');
            sb.append(Integer.toString(this.m_resolvedData[5] & 0xFF));
            return sb.toString();
        }
    }

    protected void close(int streamID) throws Exception {
        if (this.m_State == 0) {
            return;
        }
        byte[] reason = new byte[]{6};
        Integer key = new Integer(streamID);
        if (this.m_streams.containsKey(key)) {
            this.m_streams.remove(key);
            RelayCell cell = new RelayCell(this.m_circID, 3, streamID, reason);
            this.send(cell);
            if (this.m_State == 1 && this.m_streams.isEmpty()) {
                this.close();
            }
        }
    }

    public int getCircID() {
        return this.m_circID;
    }

    public synchronized TorChannel createChannel(String addr, int port) throws IOException {
        TorChannel channel = new TorChannel();
        int ret = this.connectChannel(channel, addr, port);
        if (ret != 0) {
            throw new IOException("Circuit:createChannel(addr,port) failed! Reason:" + Integer.toString(ret));
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int connectChannel(TorChannel channel, String addr, int port) {
        try {
            Integer streamID;
            if (this.isShutdown()) {
                LogHolder.log(7, LogType.TOR, "Circuit:connectChannel() - Circuit Closed - cannot connect");
                return -9;
            }
            int ret = 0;
            Circuit circuit = this;
            synchronized (circuit) {
                ++this.m_streamCounter;
                Hashtable hashtable = this.m_streams;
                synchronized (hashtable) {
                    while (this.m_streams.contains(streamID = new Integer(this.m_rand.nextInt(65535)))) {
                    }
                    channel.setStreamID(streamID);
                    channel.setCircuit(this);
                    this.m_streams.put(streamID, channel);
                }
            }
            if (!channel.connect(addr, port)) {
                circuit = this;
                synchronized (circuit) {
                    this.m_streams.remove(streamID);
                }
                LogHolder.log(7, LogType.TOR, "Circuit:connectChannel() - Channel could not be created");
                ret = -6;
            }
            if (this.m_streamCounter >= this.m_MaxStreamsPerCircuit) {
                this.shutdown();
            }
            return ret;
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.TOR, "Circuit:connectChannel() - Unkown Error", t);
            return -1;
        }
    }

    public boolean isAllowed(String adr, int port) {
        return this.m_lastORDescription.getAcl().isAllowed(adr, port);
    }

    public void setMaxNrOfStreams(int i) {
        if (i > 0 && i <= 1000) {
            this.m_MaxStreamsPerCircuit = i;
        }
        if (this.m_streamCounter >= 1000) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.m_State != 0) {
                while (this.m_cellqueueSend.isEmpty()) {
                    try {
                        if (this.m_State == 0) {
                            return;
                        }
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {}
                }
                Cell c = this.m_cellqueueSend.removeElement();
                while (this.m_sendCellCounter <= 0 && this.m_State != 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                Object object = this.m_oSendSync;
                synchronized (object) {
                    if (!(c instanceof RelayCell)) {
                        LogHolder.log(7, LogType.TOR, "Tor-Circuit-sendCellLoop: sending no releay cell.");
                    } else {
                        TorChannel channel = (TorChannel)this.m_streams.get(((RelayCell)c).getStreamID());
                        c = this.m_FirstOR.encryptCell((RelayCell)c);
                        this.addToSendCellCounter(-1);
                        if (channel != null) {
                            channel.decreaseSendRelayCellsWaitingForDelivery();
                        }
                    }
                    this.m_FirstORConnection.send(c);
                }
            }
            return;
        }
        catch (Throwable t) {
            this.destroyedByPeer();
        }
    }
}

