/*
 * Decompiled with CFR 0.152.
 */
package captcha.graphics;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class BinaryImageCreator {
    public static byte[] imageToBinary(Image a_image) {
        byte[] resultData = null;
        try {
            int width = a_image.getWidth(null);
            int height = a_image.getHeight(null);
            PixelGrabber originalImage = new PixelGrabber(a_image, 0, 0, width, height, true);
            originalImage.grabPixels();
            int[] originalImagePixels = (int[])originalImage.getPixels();
            ByteArrayOutputStream binaryData = new ByteArrayOutputStream();
            DataOutputStream transformer = new DataOutputStream(binaryData);
            transformer.writeInt(width);
            transformer.writeInt(height);
            transformer.flush();
            int currentByte = 0;
            for (int i = 0; i < width * height; ++i) {
                int currentPixel = originalImagePixels[i];
                currentByte <<= 1;
                if (currentPixel != Color.white.getRGB()) {
                    ++currentByte;
                }
                if (i % 8 != 7) continue;
                binaryData.write(currentByte);
                currentByte = 0;
            }
            if (width * height % 8 != 0) {
                binaryData.write(currentByte <<= 8 - width * height % 8);
            }
            binaryData.flush();
            resultData = binaryData.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultData;
    }
}

