/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central.server;

import infoservice.mailsystem.central.server.AbstractServerImplementation;
import infoservice.mailsystem.central.server.IServerImplementationFactory;
import infoservice.mailsystem.central.server.util.SocketContainer;
import java.net.Socket;
import logging.LogHolder;
import logging.LogType;

public class ConnectionHandle {
    public ConnectionHandle(final Socket a_newConnection, IServerImplementationFactory a_serverImplementationFactory) {
        if (a_newConnection != null) {
            boolean connectionIsHandled = false;
            if (a_serverImplementationFactory != null) {
                AbstractServerImplementation serverImplementation = a_serverImplementationFactory.createServerImplementation();
                if (serverImplementation != null) {
                    connectionIsHandled = true;
                    serverImplementation.setClientConnection(new SocketContainer(a_newConnection, null, null));
                    LogHolder.log(7, LogType.NET, "ConnectionHandle: Constructor: Server implementation successfully created.");
                    final Thread handleThread = new Thread(serverImplementation);
                    handleThread.setDaemon(true);
                    handleThread.start();
                    Thread cleanUpThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                handleThread.join();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LogHolder.log(7, LogType.NET, "ConnectionHandle: Constructor: Cleanup-Thread: Main thread finished - starting cleanup. ");
                            try {
                                a_newConnection.getInputStream().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                a_newConnection.getOutputStream().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                a_newConnection.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LogHolder.log(7, LogType.NET, "ConnectionHandle: Constructor: Cleanup-Thread: Cleanup done.");
                        }
                    });
                    cleanUpThread.setDaemon(true);
                    cleanUpThread.start();
                } else {
                    LogHolder.log(2, LogType.NET, "ConnectionHandle: Constructor: The server implementation factory returned no server implementation. Cannot handle the new connection - closing connection.");
                }
            } else {
                LogHolder.log(3, LogType.NET, "ConnectionHandle: Constructor: No server implementation factory specified. Cannot handle the new connection - closing connection.");
            }
            if (!connectionIsHandled) {
                try {
                    a_newConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    a_newConnection.getOutputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    a_newConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LogHolder.log(7, LogType.NET, "ConnectionHandle: Constructor: Connection closed after error.");
            }
        }
    }
}

