/*
 * Decompiled with CFR 0.152.
 */
package infoservice.performance;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.client.AnonClient;
import anon.error.AnonServiceException;
import anon.infoservice.Database;
import anon.infoservice.DatabaseMessage;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixCascadeExitAddresses;
import anon.infoservice.PerformanceEntry;
import anon.infoservice.ServiceSoftware;
import anon.infoservice.SimpleMixCascadeContainer;
import anon.infoservice.StatusInfo;
import anon.infoservice.update.AccountUpdater;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.proxy.AnonProxy;
import anon.util.IMiscPasswordReader;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import infoservice.Configuration;
import infoservice.performance.PerformanceRequest;
import infoservice.performance.PerformanceRequestHandler;
import infoservice.performance.PerformanceToken;
import infoservice.performance.PerformanceTokenRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PerformanceMeter
implements Runnable,
Observer {
    public static final int PERFORMANCE_ENTRY_TTL = 3600000;
    public static final String PERFORMANCE_LOG_FILE = "performance_";
    private Object SYNC_METER = new Object();
    private Object SYNC_SOCKET = new Object();
    private Object SYNC_TEST = new Object();
    private Object SYNC_INTERRUPT = new Object();
    private int m_dataSize;
    private int m_majorInterval;
    private int m_requestsPerInterval;
    private int m_maxConnectionErrorsPerRequest;
    private int m_maxWaitForTest;
    private AnonProxy m_proxy;
    private Socket m_meterSocket;
    private String m_proxyHost;
    private int m_proxyPort;
    private Configuration m_infoServiceConfig = null;
    private long m_lastUpdate = 0L;
    private long m_nextUpdate = 0L;
    private boolean m_bUpdate = false;
    private int m_lastTotalUpdates = 0;
    private long m_lastUpdateRuntime = 0L;
    private String m_lastCascadeUpdated = "(none)";
    private long m_lBytesRecvd;
    private PayAccountsFile m_payAccountsFile;
    private Hashtable m_usedAccountFiles = new Hashtable();
    private AccountUpdater m_accUpdater = null;
    private Random ms_rnd = new Random();
    private FileOutputStream m_stream = null;
    private int m_currentWeek;
    private Calendar m_cal = Calendar.getInstance();
    private InfoServiceDBEntry m_ownInfoService;

    public PerformanceMeter(AccountUpdater updater) throws IOException {
        this.init();
        this.m_accUpdater = updater;
        this.m_lBytesRecvd = 0L;
    }

    public void init() throws IOException {
        this.m_infoServiceConfig = Configuration.getInstance();
        if (this.m_infoServiceConfig == null) {
            // empty if block
        }
        Object[] a_config = this.m_infoServiceConfig.getPerformanceMeterConfig();
        this.m_proxyHost = (String)a_config[0];
        this.m_proxyPort = (Integer)a_config[1];
        this.m_dataSize = (Integer)a_config[2];
        this.m_majorInterval = (Integer)a_config[3];
        this.m_requestsPerInterval = (Integer)a_config[4];
        this.m_maxWaitForTest = (Integer)a_config[5];
        this.m_maxConnectionErrorsPerRequest = (Integer)a_config[6];
        AnonClient.setLoginTimeout(this.m_maxWaitForTest);
        this.m_cal.setTime(new Date(System.currentTimeMillis()));
        this.m_currentWeek = this.m_cal.get(3);
        if (this.m_cal.get(7) != 7) {
            this.readOldPerformanceData(this.m_currentWeek - 1);
        }
        this.readOldPerformanceData(this.m_currentWeek);
        try {
            this.m_stream = new FileOutputStream(PERFORMANCE_LOG_FILE + this.m_cal.get(1) + "_" + this.m_currentWeek + ".log", true);
        }
        catch (FileNotFoundException ex) {
            LogHolder.log(4, LogType.NET, "Could not open performance_.");
        }
        Database.getInstance(MixCascade.class).addObserver(this);
        try {
            if (this.m_proxy != null) {
                this.m_proxy.stop();
            }
            this.m_proxy = new AnonProxy(new ServerSocket(this.m_proxyPort, -1, InetAddress.getByName(this.m_proxyHost)), null, this.m_maxWaitForTest * 2);
        }
        catch (IOException a_e) {
            LogHolder.log(0, LogType.NET, "Could not start AnonProxy for performance meter on port " + this.m_proxyPort + "!");
            throw a_e;
        }
        this.m_proxy.setDummyTraffic(30000);
        this.m_proxy.setHTTPHeaderProcessingEnabled(false, false);
        this.m_ownInfoService = new InfoServiceDBEntry(Configuration.getInstance().getOwnName(), Configuration.getInstance().getID(), Configuration.getInstance().getVirtualListeners(), Configuration.getInstance().holdForwarderList(), false, System.currentTimeMillis(), 0L, Configuration.getInstance().isPerfServerEnabled(), new ServiceSoftware("IS.09.010"));
    }

    private void readOldPerformanceData(int week) {
        int year = this.m_cal.get(1);
        if (week == 0) {
            week = new GregorianCalendar(--year, 11, 31).get(3);
        }
        try {
            FileInputStream stream = new FileInputStream(PERFORMANCE_LOG_FILE + year + "_" + week + ".log");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                PerformanceEntry entry;
                long lSpeed;
                int firstTab = line.indexOf(9);
                int secondTab = line.indexOf(9, firstTab + 1);
                int thirdTab = line.indexOf(9, secondTab + 1);
                int fourthTab = line.indexOf(9, thirdTab + 1);
                int fifthTab = line.indexOf(9, fourthTab + 1);
                int sixthTab = line.indexOf(9, fifthTab + 1);
                int seventhTab = line.indexOf(9, sixthTab + 1);
                if (firstTab == -1 || secondTab == -1 || thirdTab == -1) continue;
                long timestamp = -1L;
                try {
                    timestamp = Long.parseLong(line.substring(0, firstTab));
                }
                catch (Exception e) {
                    continue;
                }
                String id = line.substring(firstTab + 1, secondTab);
                long lDelay = Integer.parseInt(line.substring(secondTab + 1, thirdTab));
                int delay = Integer.MAX_VALUE;
                if (lDelay < Integer.MAX_VALUE) {
                    delay = (int)lDelay;
                }
                int speed = Integer.MAX_VALUE;
                int users = -1;
                int packets = -1;
                if (fourthTab == -1) {
                    lSpeed = Integer.parseInt(line.substring(thirdTab + 1));
                } else {
                    lSpeed = Integer.parseInt(line.substring(thirdTab + 1, fourthTab));
                    if (fifthTab != -1 && sixthTab != -1) {
                        String strAddr;
                        int cascadeDistribution;
                        if (seventhTab != -1) {
                            cascadeDistribution = Integer.parseInt(line.substring(seventhTab + 1));
                            strAddr = line.substring(sixthTab + 1, seventhTab);
                        } else {
                            cascadeDistribution = 6;
                            strAddr = line.substring(sixthTab + 1);
                        }
                        MixCascade cascade = (MixCascade)Database.getInstance(MixCascade.class).getEntryById(id);
                        if (cascade != null) {
                            cascadeDistribution = cascade.getDistribution();
                        }
                        if (!strAddr.equals("0.0.0.0")) {
                            InetAddress addr = InetAddress.getByName(strAddr);
                            MixCascadeExitAddresses.addInetAddress(id, addr, cascadeDistribution, null);
                        }
                        packets = Integer.parseInt(line.substring(fifthTab + 1, sixthTab));
                        users = Integer.parseInt(line.substring(fourthTab + 1, fifthTab));
                    } else {
                        users = fifthTab != -1 ? Integer.parseInt(line.substring(fourthTab + 1, fifthTab)) : Integer.parseInt(line.substring(fourthTab + 1));
                    }
                }
                if (lSpeed < Integer.MAX_VALUE) {
                    speed = (int)lSpeed;
                }
                if ((entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(id)) == null) {
                    entry = new PerformanceEntry(id);
                }
                entry.importValue(1, timestamp, delay);
                entry.importValue(0, timestamp, speed);
                if (users != -1) {
                    entry.importValue(2, timestamp, users);
                }
                if (packets != -1) {
                    entry.importValue(3, timestamp, packets);
                }
                Database.getInstance(PerformanceEntry.class).update(entry);
            }
        }
        catch (IOException ex) {
            LogHolder.log(4, LogType.NET, "No previous performance data for this week found: " + ex.getMessage());
        }
        LogHolder.log(5, LogType.NET, "Added previous performance data for week" + week);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bFirstTestDone = false;
        this.loadAccountFiles();
        this.m_accUpdater.update();
        while (true) {
            Vector knownMixCascades;
            long updateBegin = System.currentTimeMillis();
            this.m_lastUpdateRuntime = 0L;
            this.m_nextUpdate = updateBegin + (long)this.m_majorInterval;
            Object object = this.SYNC_TEST;
            synchronized (object) {
                knownMixCascades = Database.getInstance(MixCascade.class).getEntryList();
            }
            this.m_lastTotalUpdates = 0;
            while (knownMixCascades.size() > 0) {
                object = this.SYNC_TEST;
                synchronized (object) {
                    LogHolder.log(6, LogType.MISC, "Cascades left to test: " + knownMixCascades.size());
                    int intRandom = Math.abs(this.ms_rnd.nextInt()) % knownMixCascades.size();
                    MixCascade cascade = (MixCascade)knownMixCascades.elementAt(intRandom);
                    knownMixCascades.removeElementAt(intRandom);
                    this.startTest(cascade);
                    if (this.m_lastTotalUpdates > 0) {
                        bFirstTestDone = true;
                        this.m_lastUpdateRuntime = System.currentTimeMillis() - updateBegin;
                    }
                }
            }
            object = this.SYNC_METER;
            synchronized (object) {
                if (!this.m_bUpdate) {
                    long sleepFor;
                    if (!bFirstTestDone) {
                        this.m_nextUpdate = System.currentTimeMillis() + 30000L;
                    }
                    if ((sleepFor = this.m_nextUpdate - System.currentTimeMillis()) > 0L) {
                        LogHolder.log(6, LogType.NET, "Performance thread sleeping for " + sleepFor + " ms.");
                        try {
                            this.SYNC_METER.wait(sleepFor);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.m_bUpdate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startTest(final MixCascade a_cascade) {
        Object account22;
        LogHolder.log(4, LogType.MISC, "Initiating performance test for service " + a_cascade + "...");
        this.loadAccountFiles();
        if (a_cascade.isPayment() && a_cascade.getPIID() != null && (account22 = PayAccountsFile.getInstance().getChargedAccount(a_cascade.getPIID(), null)) == null) {
            LogHolder.log(3, LogType.PAY, "Could not start test for cascade " + a_cascade.getName() + " because no valid account was available for PI " + a_cascade.getPIID() + "!");
            return;
        }
        LogHolder.log(4, LogType.MISC, "Create performance test thread for service " + a_cascade + "...");
        Thread performTestThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LogHolder.log(4, LogType.MISC, "Initiating performance test thread for service " + a_cascade + "...");
                if (PerformanceMeter.this.performTest(a_cascade) > 0) {
                    PerformanceMeter.this.m_lastTotalUpdates++;
                    LogHolder.log(4, LogType.MISC, "Finished performance test thread for service " + a_cascade + ".");
                }
            }
        });
        performTestThread.start();
        try {
            performTestThread.join(this.m_maxWaitForTest);
        }
        catch (InterruptedException account22) {
            // empty catch block
        }
        LogHolder.log(4, LogType.NET, "Finishing test for: " + a_cascade);
        try {
            if (performTestThread.isAlive()) {
                account22 = this.SYNC_INTERRUPT;
                synchronized (account22) {
                    performTestThread.interrupt();
                }
                this.m_proxy.stop();
                account22 = this.SYNC_INTERRUPT;
                synchronized (account22) {
                    performTestThread.interrupt();
                }
            }
            performTestThread.join(1000L);
        }
        catch (InterruptedException e) {
            LogHolder.log(3, LogType.NET, "Test was interrupted for service: " + a_cascade, e);
        }
        finally {
            this.m_proxy.stop();
        }
        int iWait = 0;
        while (performTestThread.isAlive()) {
            ++iWait;
            Object object = this.SYNC_INTERRUPT;
            synchronized (object) {
                performTestThread.interrupt();
            }
            if (this.m_proxy.isConnected()) {
                this.m_proxy.stop();
            }
            if (iWait > 5) {
                this.closeMeterSocket();
                if (iWait > 20) {
                    LogHolder.log(0, LogType.MISC, "Using deprecated stop method to finish meter thread!");
                    object = this.SYNC_INTERRUPT;
                    synchronized (object) {
                        performTestThread.stop();
                    }
                } else if (iWait > 5) {
                    LogHolder.log(0, LogType.MISC, "Problems finishing meter thread!");
                }
                try {
                    performTestThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                performTestThread.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LogHolder.log(4, LogType.NET, "Finished test for: " + a_cascade);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.SYNC_METER;
        synchronized (object) {
            this.m_bUpdate = true;
            this.m_nextUpdate = System.currentTimeMillis();
            this.SYNC_METER.notify();
        }
    }

    private boolean loadAccountFiles() {
        LogHolder.log(6, LogType.PAY, "Looking for new account files");
        Document payAccountXMLFile = null;
        File accountDir = this.m_infoServiceConfig.getPerfAccountDirectory();
        if (accountDir == null) {
            return false;
        }
        try {
            String[] files = accountDir.list();
            if (files == null) {
                return false;
            }
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = new File(accountDir.getAbsolutePath() + File.separator + files[i]);
                    PayAccount oldAccount = (PayAccount)this.m_usedAccountFiles.get(file);
                    if (oldAccount != null && oldAccount.getBackupTime() == file.lastModified()) continue;
                    LogHolder.log(5, LogType.PAY, "Trying to add " + file.getName());
                    payAccountXMLFile = XMLUtil.readXMLDocument(file);
                    Element payAccountElem = payAccountXMLFile.getDocumentElement();
                    if (!payAccountElem.getNodeName().equals("Account")) {
                        payAccountElem = (Element)XMLUtil.getFirstChildByName(payAccountElem, "Account");
                    }
                    if (payAccountElem == null) continue;
                    PayAccount payAccount = new PayAccount(payAccountElem, new PerformanceAccountPasswordReader());
                    this.m_payAccountsFile = PayAccountsFile.getInstance();
                    if (this.m_payAccountsFile == null) continue;
                    LogHolder.log(6, LogType.PAY, "Added account file " + file.getName() + ".");
                    this.m_payAccountsFile.addAccount(payAccount);
                    this.m_payAccountsFile.setActiveAccount(payAccount);
                    payAccount.setBackupDone(file.lastModified());
                    this.m_usedAccountFiles.put(file, payAccount);
                    continue;
                }
                catch (IOException e) {
                    LogHolder.log(4, LogType.PAY, "Cannot read account file " + files[i] + " for performance monitoring.", e);
                    continue;
                }
                catch (XMLParseException e) {
                    LogHolder.log(4, LogType.PAY, "Cannot parse account file " + files[i] + " for performance monitoring.", e);
                }
            }
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.PAY, "An error occured while processing the accountfiles, cause: ", e);
            return false;
        }
        return true;
    }

    private boolean isPerftestAllowed(MixCascade a_cascade) {
        Vector cascadeHosts = a_cascade.getHosts();
        Vector isHosts = this.m_infoServiceConfig.getHostList();
        Vector blackList = this.m_infoServiceConfig.getPerfBlackList();
        Vector whiteList = this.m_infoServiceConfig.getPerfWhiteList();
        for (int i = 0; i < cascadeHosts.size(); ++i) {
            String host = (String)cascadeHosts.elementAt(i);
            if (blackList.contains(host)) {
                return false;
            }
            if (!isHosts.contains(host) || whiteList.contains(host)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMeterSocket() {
        Object object = this.SYNC_SOCKET;
        synchronized (object) {
            if (this.m_meterSocket != null) {
                try {
                    this.m_meterSocket.close();
                    this.m_meterSocket = null;
                }
                catch (IOException e) {
                    LogHolder.log(4, LogType.NET, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performTest(MixCascade a_cascade) {
        int iUpdates = 0;
        int dataSize = this.m_dataSize;
        int requestsPerInterval = this.m_requestsPerInterval;
        int maxErrors = this.m_maxConnectionErrorsPerRequest;
        int errors = 0;
        int errorCode = -1;
        Hashtable hashBadInfoServices = new Hashtable();
        Hashtable<Long, Integer> vDelay = new Hashtable<Long, Integer>();
        Hashtable<Long, Integer> vSpeed = new Hashtable<Long, Integer>();
        Hashtable<Long, Integer> vUsers = new Hashtable<Long, Integer>();
        Hashtable<Long, Integer> vPackets = new Hashtable<Long, Integer>();
        if (a_cascade == null || !this.isPerftestAllowed(a_cascade)) {
            return iUpdates;
        }
        PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(a_cascade.getId());
        if (entry == null) {
            entry = new PerformanceEntry(a_cascade.getId());
        }
        LogHolder.log(4, LogType.NET, "Testing cascade " + a_cascade.getName() + "...");
        while (!Thread.currentThread().isInterrupted()) {
            AnonServiceException exception = null;
            try {
                this.m_proxy.start(new SimpleMixCascadeContainer(a_cascade));
            }
            catch (AnonServiceException a_e) {
                exception = a_e;
            }
            if (Thread.currentThread().isInterrupted()) {
                errorCode = -24;
            }
            if ((errorCode = exception == null ? 0 : exception.getErrorCode()) == -6) {
                this.m_proxy.stop();
                if (++errors > maxErrors) break;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    errorCode = -24;
                    break;
                }
            }
            if (errorCode == 0) break;
            this.m_proxy.stop();
            LogHolder.log(4, LogType.NET, "Error connecting to cascade " + a_cascade.getMixNames() + ": " + errorCode);
            break;
        }
        if (errorCode != 0 || !this.m_proxy.isConnected()) {
            LogHolder.log(4, LogType.NET, "Could not start performance test. Connection to cascade " + a_cascade.getMixNames() + " failed with error " + errorCode + ".");
        } else {
            LogHolder.log(4, LogType.NET, "Starting performance test on cascade " + a_cascade.getMixNames() + " with " + requestsPerInterval + " requests and " + this.m_maxWaitForTest + " ms timeout.");
            char[] recvBuff = new char[dataSize];
            for (int i = 0; i < requestsPerInterval && !Thread.currentThread().isInterrupted() && this.m_proxy.isConnected(); ++i) {
                try {
                    if (!this.performSingleTest(a_cascade, vDelay, vSpeed, vUsers, vPackets, hashBadInfoServices, recvBuff)) continue;
                    ++iUpdates;
                    continue;
                }
                catch (InterruptedException a_e) {
                    break;
                }
                catch (InfoServiceException a_e) {
                    LogHolder.log(4, LogType.NET, a_e);
                    requestsPerInterval = iUpdates;
                    break;
                }
            }
            LogHolder.log(5, LogType.NET, "Finished performance test on cascade " + a_cascade.getMixNames() + ".");
        }
        Object object = this.SYNC_INTERRUPT;
        synchronized (object) {
            long timestamp = System.currentTimeMillis();
            if (iUpdates > 0) {
                this.m_lastUpdate = timestamp;
                this.m_lastCascadeUpdated = a_cascade.getMixNames();
            }
            while (iUpdates < requestsPerInterval) {
                ++iUpdates;
                vDelay.put(new Long(++timestamp), new Integer(Integer.MAX_VALUE));
                vSpeed.put(new Long(timestamp), new Integer(Integer.MAX_VALUE));
                StatusInfo info = a_cascade.getCurrentStatus();
                int packets = Integer.MAX_VALUE;
                if (info != null) {
                    long lPackets = info.getMixedPackets();
                    if (lPackets >= Integer.MAX_VALUE) {
                        packets = 0x7FFFFFFE;
                    } else if (lPackets >= 0L) {
                        packets = (int)lPackets;
                    }
                }
                vUsers.put(new Long(timestamp), new Integer(info.getNrOfActiveUsers()));
                vPackets.put(new Long(timestamp), new Integer(packets));
                this.logPerftestData(timestamp, a_cascade, Integer.MAX_VALUE, Integer.MAX_VALUE, info.getNrOfActiveUsers(), packets, null);
            }
            while (timestamp - System.currentTimeMillis() > 0L) {
                try {
                    Thread.sleep(50L);
                    Thread.yield();
                }
                catch (InterruptedException e) {
                    LogHolder.log(0, LogType.MISC, e);
                }
            }
            int lastDelay = entry.addData(1, vDelay);
            int lastSpeed = entry.addData(0, vSpeed);
            int lastUsers = entry.addData(2, vUsers);
            int lastPackets = entry.addData(3, vPackets);
            Database.getInstance(PerformanceEntry.class).update(entry);
            LogHolder.log(6, LogType.NET, "Performance test for cascade " + a_cascade.getMixNames() + " done. Last Delay: " + lastDelay + " ms; Last Throughput: " + lastSpeed + " kb/s; Last Users:" + lastUsers + "; Last Packets: " + lastPackets);
            if (this.m_proxy.isConnected()) {
                this.m_proxy.stop();
            }
        }
        return iUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSingleTest(MixCascade a_cascade, Hashtable a_vDelay, Hashtable a_vSpeed, Hashtable a_vUsers, Hashtable a_vPackets, Hashtable a_hashBadInfoServices, char[] a_recvBuff) throws InterruptedException, InfoServiceException {
        if (!a_cascade.isVerified() || !a_cascade.isValid()) {
            throw new InfoServiceException("Could not measure performance for unverified service: " + a_cascade);
        }
        int delay = -1;
        int speed = -1;
        int users = Integer.MAX_VALUE;
        int packets = Integer.MAX_VALUE;
        InetAddress addr = null;
        boolean bUpdated = false;
        boolean bRetry = true;
        try {
            BufferedReader reader;
            OutputStream stream;
            HTTPResponse httpResponse;
            String xml;
            Document doc;
            String host;
            int port;
            InfoServiceDBEntry infoservice = null;
            a_cascade.fetchCurrentStatus(this.m_maxWaitForTest);
            StatusInfo info = a_cascade.getCurrentStatus();
            if (info != null) {
                users = info.getNrOfActiveUsers();
                long lPackets = info.getMixedPackets();
                if (lPackets >= Integer.MAX_VALUE) {
                    packets = 0x7FFFFFFE;
                } else if (lPackets >= 0L) {
                    packets = (int)lPackets;
                }
            }
            while (true) {
                if ((infoservice = this.chooseRandomInfoService(a_hashBadInfoServices)) == null) {
                    throw new InfoServiceException("Could not find any info services that are running a performance server.");
                }
                port = 0;
                host = null;
                int tempPort = 0;
                String tempHost = null;
                for (int i = 0; i < infoservice.getListenerInterfaces().size(); ++i) {
                    tempPort = ((ListenerInterface)infoservice.getListenerInterfaces().elementAt(i)).getPort();
                    tempHost = ((ListenerInterface)infoservice.getListenerInterfaces().elementAt(i)).getHost();
                    if (tempPort == 80) {
                        port = tempPort;
                        host = tempHost;
                        break;
                    }
                    if (tempPort != 443 && port != 0) continue;
                    port = tempPort;
                    host = tempHost;
                }
                if (host == null) {
                    throw new InfoServiceException("No network interface found for connection!");
                }
                PerformanceTokenRequest tokenRequest = new PerformanceTokenRequest(Configuration.getInstance().getID());
                doc = XMLUtil.toSignedXMLDocument(tokenRequest, 2);
                xml = XMLUtil.toString(doc);
                LogHolder.log(5, LogType.NET, "Requesting performance token");
                HTTPConnection conn = new HTTPConnection(host, port);
                httpResponse = conn.Post("/requestperformancetoken", xml);
                if (httpResponse.getStatusCode() == 200 && !Thread.currentThread().isInterrupted()) break;
                LogHolder.log(4, LogType.NET, "Token request to performance server failed. Status Code: " + httpResponse.getStatusCode());
                httpResponse = null;
                if (Thread.currentThread().isInterrupted()) break;
                a_hashBadInfoServices.put(infoservice.getId(), infoservice);
            }
            if (httpResponse == null) {
                throw new InfoServiceException("Error while reading from infoservice");
            }
            PerformanceToken token = null;
            try {
                doc = XMLUtil.toXMLDocument(httpResponse.getData());
                token = new PerformanceToken(doc.getDocumentElement());
                LogHolder.log(5, LogType.NET, "Received Token " + token.getId() + ".");
            }
            catch (XMLParseException ex) {
                LogHolder.log(3, LogType.NET, "Error while parsing performance token!", ex);
                return bUpdated;
            }
            LogHolder.log(5, LogType.NET, "Trying to reach infoservice random data page at " + host + ":" + port + " through the mixcascade " + a_cascade.getListenerInterface(0).getHost() + ".");
            Object ex = this.SYNC_SOCKET;
            synchronized (ex) {
                this.m_meterSocket = new Socket(this.m_proxyHost, this.m_proxyPort);
                this.m_meterSocket.setSoTimeout(this.m_maxWaitForTest);
                stream = this.m_meterSocket.getOutputStream();
                reader = new BufferedReader(new InputStreamReader(this.m_meterSocket.getInputStream()));
            }
            PerformanceRequest perfRequest = new PerformanceRequest(token.getId(), a_recvBuff.length);
            doc = XMLUtil.toSignedXMLDocument(perfRequest, 2);
            xml = XMLUtil.toString(doc);
            LogHolder.log(5, LogType.NET, "Requesting performance data");
            stream.write(("POST http://" + host + ":" + port + "/requestperformance HTTP/1.0\r\n").getBytes());
            stream.write(("Content-Length: " + xml.length() + "\r\n\r\n").getBytes());
            stream.write((xml + "\r\n").getBytes());
            long transferInitiatedTime = System.currentTimeMillis();
            LogHolder.log(6, LogType.NET, "Reading first byte for performance test...");
            reader.mark(2);
            if (reader.read() < 0) {
                this.closeMeterSocket();
                throw new Exception("Error while reading from socket");
            }
            long responseStartTime = System.currentTimeMillis();
            delay = responseStartTime - transferInitiatedTime >= Integer.MAX_VALUE ? 0x7FFFFFFE : (int)(responseStartTime - transferInitiatedTime);
            LogHolder.log(6, LogType.NET, "Downloading bytes for performance test...");
            reader.reset();
            HTTPResponseHeader resp = null;
            resp = this.parseHTTPHeader(reader);
            if (resp == null || resp.m_statusCode != 200) {
                LogHolder.log(4, LogType.NET, "Request to Performance Server failed." + (resp != null ? " Status Code: " + resp.m_statusCode : ""));
                this.closeMeterSocket();
                if (bRetry) {
                    bRetry = false;
                    if (this.m_proxy.isConnected()) {
                        this.m_proxy.stop();
                    }
                    this.m_proxy.start(new SimpleMixCascadeContainer(a_cascade));
                    if (this.m_proxy.isConnected()) {
                        bRetry = true;
                    }
                }
                throw new Exception("Error while reading from mix cascade");
            }
            LogHolder.log(7, LogType.NET, "Performance meter parsed server header.");
            if (resp.m_contentLength != a_recvBuff.length) {
                LogHolder.log(3, LogType.NET, "Performance Meter could not verify incoming package. Specified invalid Content-Length " + resp.m_contentLength + " of " + a_recvBuff.length + " bytes.");
                this.closeMeterSocket();
                throw new Exception("Invalid Packet-Length");
            }
            int bytesRead = 0;
            int recvd = 0;
            int toRead = resp.m_contentLength;
            while (bytesRead < a_recvBuff.length && (recvd = reader.read(a_recvBuff, bytesRead, toRead)) != -1) {
                bytesRead += recvd;
                toRead -= recvd;
            }
            long responseEndTime = System.currentTimeMillis();
            int ipSize = 0;
            if ((byte)a_recvBuff[0] == PerformanceRequestHandler.MAGIC_BYTES_IPV4[0] && (byte)a_recvBuff[1] == PerformanceRequestHandler.MAGIC_BYTES_IPV4[1] && (byte)a_recvBuff[2] == PerformanceRequestHandler.MAGIC_BYTES_IPV4[2] && (byte)a_recvBuff[3] == PerformanceRequestHandler.MAGIC_BYTES_IPV4[3]) {
                ipSize = 4;
            } else if ((byte)a_recvBuff[0] == PerformanceRequestHandler.MAGIC_BYTES_IPV6[0] && (byte)a_recvBuff[1] == PerformanceRequestHandler.MAGIC_BYTES_IPV6[1] && (byte)a_recvBuff[2] == PerformanceRequestHandler.MAGIC_BYTES_IPV6[2] && (byte)a_recvBuff[3] == PerformanceRequestHandler.MAGIC_BYTES_IPV6[3]) {
                ipSize = 16;
            }
            addr = null;
            if (ipSize > 0) {
                byte[] ip = new byte[ipSize];
                int i = 0;
                int j = ipSize;
                while (i < ipSize) {
                    ip[i] = (byte)a_recvBuff[4 + i];
                    if (a_recvBuff[4 + j] == '\u0001') {
                        ip[i] = (byte)(ip[i] ^ 0xFFFFFF80);
                    }
                    ++i;
                    ++j;
                }
                try {
                    addr = InetAddress.getByAddress(ip);
                }
                catch (Exception ex2) {
                    LogHolder.log(4, LogType.NET, "Could not parse IP address", ex2);
                }
            }
            if (bytesRead != a_recvBuff.length) {
                LogHolder.log(4, LogType.NET, "Performance Meter could not get all requested bytes. Received " + bytesRead + " of " + a_recvBuff.length + " bytes.");
            }
            if ((bytesRead += resp.m_headerBytes) < 100000) {
                LogHolder.log(4, LogType.NET, "Too few bytes for measuring speed: " + bytesRead + " bytes.");
                bytesRead = 0;
            } else if (addr != null) {
                MixCascadeExitAddresses.addInetAddress(a_cascade.getId(), addr, a_cascade.getDistribution(), null);
            }
            long lSpeed = (long)(bytesRead * 8) / (responseEndTime - responseStartTime);
            speed = lSpeed <= 0L || lSpeed > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lSpeed;
            LogHolder.log(6, LogType.NET, "Verified incoming package. Delay: " + delay + " ms - Speed: " + speed + " kbit/s.");
            this.m_lBytesRecvd += (long)bytesRead;
            bUpdated = true;
        }
        catch (InterruptedIOException a_e) {
            LogHolder.log(4, LogType.NET, a_e);
        }
        catch (InterruptedException a_e) {
            this.closeMeterSocket();
            throw a_e;
        }
        catch (InfoServiceException a_e) {
            this.closeMeterSocket();
            throw a_e;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.NET, e);
        }
        this.closeMeterSocket();
        Object object = this.SYNC_INTERRUPT;
        synchronized (object) {
            long timestamp = System.currentTimeMillis();
            a_vDelay.put(new Long(timestamp), new Integer(delay));
            a_vSpeed.put(new Long(timestamp), new Integer(speed));
            a_vUsers.put(new Long(timestamp), new Integer(users));
            a_vPackets.put(new Long(timestamp), new Integer(packets));
            this.logPerftestData(timestamp, a_cascade, delay, speed, users, packets, addr);
        }
        return bUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPerftestData(long a_timestamp, MixCascade a_cascade, int a_delay, int a_speed, int a_users, int a_packets, InetAddress a_ip) {
        try {
            Object object = this.SYNC_INTERRUPT;
            synchronized (object) {
                this.m_cal.setTimeInMillis(System.currentTimeMillis());
                if (this.m_cal.get(3) != this.m_currentWeek) {
                    this.m_currentWeek = this.m_cal.get(3);
                    this.m_stream.close();
                    this.m_stream = new FileOutputStream(PERFORMANCE_LOG_FILE + this.m_cal.get(1) + "_" + this.m_currentWeek + ".log", true);
                }
                this.m_stream.write((a_timestamp + "\t" + a_cascade.getId() + "\t" + a_delay + "\t" + a_speed + "\t" + a_users + "\t" + a_packets + "\t" + (a_ip == null ? "0.0.0.0" : a_ip.getHostAddress()) + "\t" + a_cascade.getDistribution() + "\n").getBytes());
                this.m_stream.flush();
            }
        }
        catch (IOException ex) {
            LogHolder.log(2, LogType.NET, ex);
        }
    }

    public HTTPResponseHeader parseHTTPHeader(BufferedReader a_reader) throws IOException, NumberFormatException {
        String line;
        HTTPResponseHeader r = new HTTPResponseHeader();
        int i = 0;
        do {
            if ((line = a_reader.readLine()) == null || i == 0 && !line.startsWith("HTTP")) {
                return null;
            }
            r.m_headerBytes += line.length() + 2;
            if (line.startsWith("HTTP")) {
                int c = line.indexOf(" ");
                if (c == -1) {
                    return null;
                }
                r.m_statusCode = Integer.parseInt(line.substring(c + 1, c + 4));
            } else if (line.startsWith("Content-Length: ")) {
                r.m_contentLength = Integer.parseInt(line.substring(16));
            }
            ++i;
        } while (line.length() > 0);
        return r;
    }

    public int getLastTotalUpdates() {
        return this.m_lastTotalUpdates;
    }

    public long getLastUpdateRuntime() {
        return this.m_lastUpdateRuntime;
    }

    public long getLastSuccessfulUpdate() {
        return this.m_lastUpdate;
    }

    public long getNextUpdate() {
        return this.m_nextUpdate;
    }

    public String getLastCascadeUpdated() {
        return this.m_lastCascadeUpdated;
    }

    public long getBytesRecvd() {
        return this.m_lBytesRecvd;
    }

    public Hashtable getUsedAccountFiles() {
        return this.m_usedAccountFiles;
    }

    public long calculateRemainingPayTime(String a_piid) {
        long trafficPerTest = this.calculatePayTrafficPerTest(a_piid);
        if (trafficPerTest == 0L) {
            return 0L;
        }
        long remainingTests = this.getRemainingCredit(a_piid) / trafficPerTest;
        return System.currentTimeMillis() + remainingTests * (long)this.m_majorInterval;
    }

    private long calculatePayTrafficPerTest(String a_piid) {
        int payCascades = 0;
        long trafficPerTest = 0L;
        for (MixCascade cascade : Database.getInstance(MixCascade.class).getEntryList()) {
            if (!cascade.isPayment() || cascade.getPIID() == null || !cascade.getPIID().equals(a_piid) || !this.isPerftestAllowed(cascade)) continue;
            ++payCascades;
        }
        trafficPerTest = payCascades * this.m_requestsPerInterval * this.m_dataSize;
        return trafficPerTest;
    }

    public long calculatePayTrafficPerDay(String a_piid) {
        int testsPerDay = 86400000 / this.m_majorInterval;
        return this.calculatePayTrafficPerTest(a_piid) * (long)testsPerDay;
    }

    public long getRemainingCredit(String a_piid) {
        if (a_piid == null || this.m_payAccountsFile == null) {
            return 0L;
        }
        Enumeration accounts = this.m_payAccountsFile.getAccounts();
        long credit = 0L;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        while (accounts.hasMoreElements()) {
            PayAccount account = (PayAccount)accounts.nextElement();
            if (account.getBI() == null || !account.getBI().getId().equals(a_piid) || !account.isCharged(now)) continue;
            credit += account.getCurrentCredit();
        }
        return credit;
    }

    private InfoServiceDBEntry chooseRandomInfoService(Hashtable a_badInfoServices) {
        if (!a_badInfoServices.containsKey(Configuration.getInstance().getID())) {
            return this.m_ownInfoService;
        }
        Vector knownIS = Database.getInstance(InfoServiceDBEntry.class).getEntryList();
        while (!knownIS.isEmpty()) {
            int i = this.ms_rnd.nextInt(knownIS.size());
            InfoServiceDBEntry entry = (InfoServiceDBEntry)knownIS.elementAt(i);
            if (!a_badInfoServices.containsKey(entry.getId()) && entry.isPerfServerEnabled() && !entry.getListenerInterfaces().isEmpty()) {
                return entry;
            }
            a_badInfoServices.put(entry.getId(), entry);
            knownIS.remove(entry);
        }
        return null;
    }

    @Override
    public void update(Observable a_observable, Object a_message) {
        DatabaseMessage msg;
        if (a_message != null && a_message instanceof DatabaseMessage && (msg = (DatabaseMessage)a_message).getMessageCode() == 1) {
            try {
                final MixCascade cascade = (MixCascade)msg.getMessageData();
                final PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(cascade.getId());
                if (entry == null) {
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = PerformanceMeter.this.SYNC_TEST;
                            synchronized (object) {
                                if (entry == null || System.currentTimeMillis() - entry.getLastUpdate() >= (long)PerformanceMeter.this.m_majorInterval) {
                                    LogHolder.log(6, LogType.MISC, "Found new cascade, starting performance test immediately.");
                                    PerformanceMeter.this.startTest(cascade);
                                }
                            }
                        }
                    }).start();
                }
            }
            catch (Exception ex) {
                LogHolder.log(2, LogType.MISC, "Error while starting performance test for new cascade: ", ex);
            }
        }
    }

    private final class InfoServiceException
    extends Exception {
        public InfoServiceException(String a_message) {
            super(a_message);
        }
    }

    private final class PerformanceAccountPasswordReader
    implements IMiscPasswordReader {
        private PerformanceAccountPasswordReader() {
        }

        @Override
        public String readPassword(Object a_message) {
            return PerformanceMeter.this.m_infoServiceConfig.getPerfAccountPassword();
        }
    }

    private class HTTPResponseHeader {
        int m_statusCode = -1;
        int m_contentLength = 0;
        int m_headerBytes = 0;

        private HTTPResponseHeader() {
        }
    }
}

