/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.XMLSignature;
import anon.pay.PayMessage;
import anon.pay.Transaction;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBalance
implements IXMLEncodable {
    private static final String DEFAULT_RATE_ENDDATE = "3000-01-01 00:00:00.00000000";
    private static final String DEFAULT_RATE_STARTDATE = "1970-01-01 00:00:00.00000000";
    private long m_lAccountNumber;
    private Timestamp m_Timestamp;
    private Timestamp m_tStartDate;
    private Timestamp m_ValidTime;
    private long m_lDeposit;
    private boolean m_bBlocked = false;
    private Transaction m_transaction;
    private long m_lSpent;
    private long m_lVolumeBytesMonthly;
    private Timestamp m_flatEnddate;
    private long m_volumeKBytesleft;
    private long m_volumeBytesleft;
    private long m_lOverusageBytes = 0L;
    private Timestamp m_tOverusageDate = null;
    private double m_dFactorOverusageGeneral = 0.0;
    private double m_dFactorOverusageUser = 0.0;
    private String m_message;
    private String m_messageText;
    private URL m_messageLink;
    private Timestamp m_tMonthlyBytesUpdatedOn = new Timestamp(0L);
    private long m_lLastMonthRemainingTraffic;
    private Document m_docTheBalance = null;
    private String m_strAffiliate;

    public XMLBalance(long accountNumber, long deposit, long spent, Timestamp timestamp, Timestamp validTime, long volumeBytesleft, Timestamp flatEnddate, IMyPrivateKey signKey, long a_lVolumeBytesMonthly, Timestamp a_tMonthlyBytesUpdatedOn, Timestamp a_tStartDate, long a_lOverusageBytes, Timestamp a_tOverusageDate, double a_dFactorOverusageGeneral, double a_dFactorOverusageUser, long a_lLastMonthRemainingTraffic, boolean a_bBlocked, String a_strAffiliate, Transaction a_transaction) {
        this.m_transaction = a_transaction;
        this.m_bBlocked = a_bBlocked;
        this.m_strAffiliate = a_strAffiliate;
        this.m_lLastMonthRemainingTraffic = a_lLastMonthRemainingTraffic;
        this.m_dFactorOverusageGeneral = a_dFactorOverusageGeneral;
        this.m_dFactorOverusageUser = a_dFactorOverusageUser;
        this.m_lOverusageBytes = a_lOverusageBytes;
        this.m_tOverusageDate = a_tOverusageDate;
        this.m_lDeposit = deposit;
        this.m_lSpent = spent;
        this.m_Timestamp = timestamp;
        this.m_tMonthlyBytesUpdatedOn = a_tMonthlyBytesUpdatedOn;
        this.m_lVolumeBytesMonthly = a_lVolumeBytesMonthly;
        if (this.m_Timestamp == null) {
            this.m_Timestamp = new Timestamp(System.currentTimeMillis());
        }
        this.m_ValidTime = validTime;
        if (this.m_ValidTime == null) {
            this.m_ValidTime = Timestamp.valueOf(DEFAULT_RATE_ENDDATE);
        }
        this.m_lAccountNumber = accountNumber;
        this.m_volumeKBytesleft = volumeBytesleft / 1000L;
        this.m_volumeBytesleft = volumeBytesleft;
        this.m_flatEnddate = flatEnddate;
        if (this.m_flatEnddate == null) {
            this.m_flatEnddate = Timestamp.valueOf(DEFAULT_RATE_ENDDATE);
        }
        this.m_tStartDate = a_tStartDate;
        if (this.m_tStartDate == null) {
            this.m_tStartDate = Timestamp.valueOf(DEFAULT_RATE_STARTDATE);
        }
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(this.internal_toXmlElement(this.m_docTheBalance));
        if (signKey != null) {
            this.sign(signKey);
        }
    }

    public void sign(IMyPrivateKey signKey) {
        try {
            XMLSignature.sign((Node)this.m_docTheBalance, signKey, 0);
        }
        catch (XMLParseException e) {
            LogHolder.log(7, LogType.PAY, "Could not sign XMLBalance");
        }
    }

    public void setMessage(PayMessage a_message) {
        if (a_message == null) {
            this.m_message = null;
            this.m_messageLink = null;
            this.m_messageText = null;
        } else {
            this.m_message = a_message.getShortMessage();
            this.m_messageLink = a_message.getMessageLink();
            this.m_messageText = a_message.getMessageText();
        }
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(this.internal_toXmlElement(this.m_docTheBalance));
    }

    public XMLBalance(Document doc) throws Exception {
        this.setValues(doc.getDocumentElement());
        this.m_docTheBalance = doc;
    }

    public XMLBalance(String xmlDoc) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xmlDoc);
        this.setValues(doc.getDocumentElement());
        this.m_docTheBalance = doc;
    }

    public XMLBalance(Element elemBalance) throws Exception {
        this.setValues(elemBalance);
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(XMLUtil.importNode(this.m_docTheBalance, elemBalance, true));
    }

    private void setValues(Element elemRoot) throws Exception {
        block21: {
            boolean isBase64;
            String str;
            Element elem;
            block20: {
                if (!elemRoot.getTagName().equals("Balance") || !elemRoot.getAttribute("version").equals("1.0")) {
                    throw new Exception("Balance wrong XML format");
                }
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "AccountNumber");
                str = XMLUtil.parseValue((Node)elem, (String)null);
                this.m_lAccountNumber = Long.parseLong(str);
                Node node = XMLUtil.getFirstChildByName(elemRoot, "Transaction");
                if (node instanceof Element && node != null) {
                    this.m_transaction = new Transaction((Element)node);
                }
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Blocked");
                this.m_bBlocked = XMLUtil.parseValue((Node)elem, false);
                this.m_strAffiliate = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, "Affiliate"), null);
                if (this.m_strAffiliate != null && this.m_strAffiliate.endsWith("_null")) {
                    this.m_strAffiliate = null;
                }
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Deposit");
                str = XMLUtil.parseValue((Node)elem, (String)null);
                this.m_lDeposit = Long.parseLong(str);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Spent");
                str = XMLUtil.parseValue((Node)elem, (String)null);
                this.m_lSpent = Long.parseLong(str);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "BalanceInCent");
                str = XMLUtil.parseValue((Node)elem, "0");
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "FlatrateEnddate");
                str = XMLUtil.parseValue((Node)elem, DEFAULT_RATE_ENDDATE);
                this.m_flatEnddate = Timestamp.valueOf(str);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "OverusageBytes");
                if (XMLUtil.parseAttribute((Node)elem, "overusageDate", null) != null) {
                    this.m_tOverusageDate = Timestamp.valueOf(XMLUtil.parseAttribute((Node)elem, "overusageDate", null));
                }
                this.m_lLastMonthRemainingTraffic = XMLUtil.parseAttribute((Node)elem, "lastMonthRemainingTraffic", 0L);
                this.m_dFactorOverusageGeneral = XMLUtil.parseAttribute((Node)elem, "overusageFactorGeneral", 0.0);
                this.m_dFactorOverusageUser = XMLUtil.parseAttribute((Node)elem, "overusageFactorUser", 0.0);
                this.m_lOverusageBytes = XMLUtil.parseValue((Node)elem, 0L);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "StartDate");
                str = XMLUtil.parseValue((Node)elem, DEFAULT_RATE_STARTDATE);
                this.m_tStartDate = Timestamp.valueOf(str);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "VolumeBytesLeft");
                this.m_volumeKBytesleft = XMLUtil.parseValue((Node)elem, 0L);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "BytesLeft");
                this.m_volumeBytesleft = XMLUtil.parseValue((Node)elem, 0L);
                if (this.m_volumeBytesleft == 0L) {
                    this.m_volumeBytesleft = this.m_volumeKBytesleft * 1000L;
                }
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "VolumeBytesMonthly");
                this.m_lVolumeBytesMonthly = XMLUtil.parseValue((Node)elem, 0L);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Timestamp");
                str = XMLUtil.parseValue((Node)elem, (String)null);
                this.m_Timestamp = str != null ? Timestamp.valueOf(str) : new Timestamp(System.currentTimeMillis());
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Validtime");
                str = XMLUtil.parseValue((Node)elem, DEFAULT_RATE_ENDDATE);
                this.m_ValidTime = Timestamp.valueOf(str);
                elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Message");
                if (elem != null) {
                    isBase64 = XMLUtil.parseAttribute((Node)elem, "encoded", false);
                    if (isBase64) {
                        try {
                            str = XMLUtil.parseValue((Node)elem, "");
                            if (!str.equals("")) {
                                this.m_message = Base64.decodeToString(str);
                                break block20;
                            }
                            this.m_message = "";
                        }
                        catch (Exception e) {
                            LogHolder.log(7, LogType.PAY, "Error while reading message: " + e + ", message (Base64) was" + str + "decoded message was" + this.m_message);
                        }
                    } else {
                        this.m_message = XMLUtil.parseValue((Node)elem, "");
                    }
                }
            }
            if ((elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "MessageLink")) != null && !(str = XMLUtil.parseValue((Node)elem, "")).equals("")) {
                try {
                    this.m_messageLink = new URL(str);
                }
                catch (MalformedURLException mue) {
                    LogHolder.log(7, LogType.PAY, "Could not get URL from messagelink string: " + str + ", reason: " + mue);
                }
            }
            if ((elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "MessageText")) != null) {
                isBase64 = XMLUtil.parseAttribute((Node)elem, "encoded", false);
                if (isBase64) {
                    try {
                        str = XMLUtil.parseValue((Node)elem, "");
                        if (!str.equals("")) {
                            this.m_messageText = Base64.decodeToString(str);
                            break block21;
                        }
                        this.m_messageText = "";
                    }
                    catch (Exception e) {
                        LogHolder.log(7, LogType.PAY, "Error while reading message: " + e + ", message (Base64) was" + str + "decoded message was" + this.m_message);
                    }
                } else {
                    this.m_messageText = XMLUtil.parseValue((Node)elem, "");
                }
            }
        }
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("Balance");
        elemRoot.setAttribute("version", "1.0");
        Element elem = a_doc.createElement("AccountNumber");
        XMLUtil.setValue((Node)elem, this.m_lAccountNumber);
        elemRoot.appendChild(elem);
        if (this.m_transaction != null) {
            elemRoot.appendChild(this.m_transaction.toXmlElement(a_doc));
        }
        elem = a_doc.createElement("Blocked");
        XMLUtil.setValue((Node)elem, this.m_bBlocked);
        elemRoot.appendChild(elem);
        if (this.m_strAffiliate != null) {
            elem = a_doc.createElement("Affiliate");
            XMLUtil.setValue((Node)elem, this.m_strAffiliate);
            elemRoot.appendChild(elem);
        }
        elem = a_doc.createElement("Deposit");
        XMLUtil.setValue((Node)elem, this.m_lDeposit);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Spent");
        XMLUtil.setValue((Node)elem, this.m_lSpent);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("FlatrateEnddate");
        XMLUtil.setValue((Node)elem, this.m_flatEnddate.toString());
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("OverusageBytes");
        XMLUtil.setValue((Node)elem, this.m_lOverusageBytes);
        if (this.m_tOverusageDate != null) {
            XMLUtil.setAttribute(elem, "overusageDate", this.m_tOverusageDate.toString());
        }
        XMLUtil.setAttribute(elem, "lastMonthRemainingTraffic", this.m_lLastMonthRemainingTraffic);
        XMLUtil.setAttribute(elem, "overusageFactorGeneral", this.m_dFactorOverusageGeneral);
        XMLUtil.setAttribute(elem, "overusageFactorUser", this.m_dFactorOverusageUser);
        elemRoot.appendChild(elem);
        if (this.m_tStartDate != null) {
            elem = a_doc.createElement("StartDate");
            XMLUtil.setValue((Node)elem, this.m_tStartDate.toString());
            elemRoot.appendChild(elem);
        }
        elem = a_doc.createElement("VolumeBytesLeft");
        XMLUtil.setValue((Node)elem, this.m_volumeKBytesleft);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("BytesLeft");
        XMLUtil.setValue((Node)elem, this.m_volumeBytesleft);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("VolumeBytesMonthly");
        XMLUtil.setValue((Node)elem, this.m_lVolumeBytesMonthly);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Timestamp");
        XMLUtil.setValue((Node)elem, this.m_Timestamp.toString());
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Validtime");
        XMLUtil.setValue((Node)elem, this.m_ValidTime.toString());
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Message");
        if (this.m_message != null) {
            String encodedMessage = Base64.encodeString(this.m_message);
            XMLUtil.setValue((Node)elem, encodedMessage);
            XMLUtil.setAttribute(elem, "encoded", true);
        }
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("MessageText");
        if (this.m_messageText != null) {
            String encodedMessageText = Base64.encodeString(this.m_messageText);
            XMLUtil.setAttribute(elem, "encoded", true);
            XMLUtil.setValue((Node)elem, encodedMessageText);
        }
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("MessageLink");
        if (this.m_messageLink != null) {
            XMLUtil.setValue((Node)elem, this.m_messageLink.toString());
        }
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public long getAccountNumber() {
        return this.m_lAccountNumber;
    }

    public double getOverusageFactorGeneral() {
        return this.m_dFactorOverusageGeneral;
    }

    public double getOverusageFactor() {
        return this.m_dFactorOverusageUser;
    }

    public String getAffiliate() {
        return this.m_strAffiliate;
    }

    public boolean isBlocked() {
        return this.m_bBlocked;
    }

    public long getDeposit() {
        return this.m_lDeposit;
    }

    public Transaction getTransaction() {
        return this.m_transaction;
    }

    public long getSpent() {
        return this.m_lSpent;
    }

    public long getOverusageBytes() {
        return this.m_lOverusageBytes;
    }

    public Timestamp getOverusageDate() {
        return this.m_tOverusageDate;
    }

    public Timestamp getMonthlyBytesUpdatedOn() {
        return this.m_tMonthlyBytesUpdatedOn;
    }

    public long getVolumeBytesMonthly() {
        return this.m_lVolumeBytesMonthly;
    }

    public long getLastMonthRemainingTraffic() {
        return this.m_lLastMonthRemainingTraffic;
    }

    public long getVolumeBytesLeft() {
        return this.m_volumeBytesleft;
    }

    public Timestamp getStartDate() {
        return this.m_tStartDate;
    }

    public Timestamp getFlatEnddate() {
        return this.m_flatEnddate;
    }

    public Timestamp getTimestamp() {
        return this.m_Timestamp;
    }

    public Timestamp getValidTime() {
        return this.m_ValidTime;
    }

    public PayMessage getMessage() {
        if (this.m_message == null || this.m_message.equals("")) {
            return null;
        }
        return new PayMessage(this.m_message, this.m_messageText, this.m_messageLink);
    }

    public MonthlyOverusage calculateMonthlyOverusage(Timestamp a_tNow) {
        MonthlyOverusage overusage = null;
        if (this.canDoMonthlyOverusage(a_tNow)) {
            overusage = new MonthlyOverusage();
            overusage.m_tEndOfCurrentPeriod = XMLBalance.calculateEndOfCurrentMonthlyPeriod(this.getFlatEnddate(), a_tNow);
            overusage.m_dFactor = this.getOverusageFactorGeneral();
            overusage.m_lAdditionalTraffic = this.getVolumeBytesMonthly() * (long)XMLBalance.calculateRemainingRateMonths(this.getFlatEnddate(), a_tNow);
            if (overusage.m_lAdditionalTraffic > 0L && this.getLastMonthRemainingTraffic() > 0L) {
                overusage.m_lAdditionalTraffic = overusage.m_lAdditionalTraffic - this.getVolumeBytesMonthly() + this.getLastMonthRemainingTraffic();
            }
            overusage.m_lAdditionalTraffic = (long)((double)overusage.m_lAdditionalTraffic / this.getOverusageFactorGeneral());
        } else if (this.isCurrentlyInOverusage(a_tNow)) {
            overusage = new MonthlyOverusage();
            overusage.m_dFactor = this.getOverusageFactor();
            overusage.m_lAdditionalTraffic = this.getOverusageBytes();
            overusage.m_tEndOfCurrentPeriod = XMLBalance.calculateEndOfCurrentMonthlyPeriod(this.getFlatEnddate(), a_tNow);
        }
        return overusage;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheBalance.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCurrentlyInOverusage(Timestamp a_tNow) {
        return this.getOverusageDate() != null && XMLBalance.isSameMonthlyPeriod(this.getOverusageDate(), a_tNow, this.getStartDate(), true);
    }

    public boolean canDoMonthlyOverusage(Timestamp a_tNow) {
        return this.getVolumeBytesMonthly() > 0L && this.getStartDate() != null && !this.getStartDate().after(a_tNow) && XMLBalance.calculateRemainingRateMonths(this.getFlatEnddate(), a_tNow) > 0 && (this.getOverusageDate() == null || !XMLBalance.isSameMonthlyPeriod(this.getOverusageDate(), a_tNow, this.getStartDate(), true)) && this.getOverusageFactorGeneral() > 1.0 && this.getLastMonthRemainingTraffic() > 0L;
    }

    public static boolean isSameMonthlyPeriod(Timestamp a_tUpdatedOn, Timestamp a_tNow, Timestamp a_tStartDate, boolean a_bUpdatedOnEarlier) {
        GregorianCalendar calendarUpdatedOn = new GregorianCalendar();
        GregorianCalendar calendarNow = new GregorianCalendar();
        GregorianCalendar calendarStart = new GregorianCalendar();
        if (a_tStartDate == null) {
            return true;
        }
        if (a_tUpdatedOn == null || a_tNow == null) {
            return false;
        }
        calendarUpdatedOn.setTime(a_tUpdatedOn);
        calendarNow.setTime(a_tNow);
        calendarStart.setTime(a_tStartDate);
        return XMLBalance.isSameMonthlyPeriod(calendarUpdatedOn, calendarNow, calendarStart, a_bUpdatedOnEarlier);
    }

    private static boolean isSameMonthlyPeriod(Calendar calendarUpdatedOn, Calendar calendarNow, Calendar calendarStart, boolean a_bUpdatedOnEarlier) {
        GregorianCalendar calendarNowLastMonth = new GregorianCalendar();
        calendarNowLastMonth.setTime(calendarNow.getTime());
        ((Calendar)calendarNowLastMonth).add(2, -1);
        if (a_bUpdatedOnEarlier && calendarUpdatedOn.getTime().getTime() > calendarNow.getTime().getTime()) {
            return true;
        }
        calendarStart.set(1, calendarUpdatedOn.get(1));
        calendarStart.set(2, calendarUpdatedOn.get(2));
        if (calendarUpdatedOn.get(2) == calendarNow.get(2)) {
            if (calendarUpdatedOn.get(1) != calendarNow.get(1)) {
                return false;
            }
            if (calendarUpdatedOn.get(5) >= calendarStart.get(5) && calendarNow.get(5) >= calendarStart.get(5) || calendarUpdatedOn.get(5) < calendarStart.get(5) && calendarNow.get(5) < calendarStart.get(5)) {
                return true;
            }
        } else if (calendarUpdatedOn.get(2) == calendarNowLastMonth.get(2)) {
            if (calendarUpdatedOn.get(1) != calendarNowLastMonth.get(1)) {
                return false;
            }
            if (calendarUpdatedOn.get(5) >= calendarStart.get(5) && calendarNowLastMonth.get(5) < calendarStart.get(5)) {
                return true;
            }
        }
        return false;
    }

    public static int calculateRemainingRateMonths(Calendar a_calendarEnd, Calendar a_calendarNow) {
        return XMLBalance.calculateRemainingRateMonths(new Timestamp(a_calendarEnd.getTime().getTime()), new Timestamp(a_calendarNow.getTime().getTime()));
    }

    public static Timestamp calculateEndOfCurrentMonthlyPeriod(Timestamp a_tEnd, Timestamp a_tNow) {
        if (a_tEnd == null || a_tNow == null) {
            return null;
        }
        GregorianCalendar a_calendarEnd = new GregorianCalendar();
        a_calendarEnd.setTime(a_tEnd);
        GregorianCalendar a_calendarNow = new GregorianCalendar();
        a_calendarNow.setTime(a_tNow);
        return new Timestamp(XMLBalance.calculateEndOfCurrentMonthlyPeriod(a_calendarEnd, a_calendarNow).getTime().getTime());
    }

    public static Calendar calculateEndOfCurrentMonthlyPeriod(Calendar a_calendarEnd, Calendar a_calendarNow) {
        if (a_calendarEnd == null || a_calendarNow == null) {
            return null;
        }
        Calendar calendarEndBillingPeriod = (Calendar)a_calendarEnd.clone();
        calendarEndBillingPeriod.set(1, a_calendarNow.get(1));
        calendarEndBillingPeriod.set(2, a_calendarNow.get(2));
        if (a_calendarNow.get(5) > calendarEndBillingPeriod.get(5)) {
            calendarEndBillingPeriod.add(2, 1);
        }
        return calendarEndBillingPeriod;
    }

    public static int calculateRemainingRateMonths(Timestamp a_tEnd, Timestamp a_tNow) {
        if (a_tEnd == null || a_tNow == null || a_tEnd.getTime() < a_tNow.getTime()) {
            return 0;
        }
        GregorianCalendar calendarEnd = new GregorianCalendar();
        GregorianCalendar calendarNow = new GregorianCalendar();
        calendarEnd.setTime(a_tEnd);
        calendarNow.setTime(a_tNow);
        int iRateMonths = 0;
        if (calendarEnd.get(1) != calendarNow.get(1)) {
            iRateMonths += 12 * (calendarEnd.get(1) - calendarNow.get(1));
            calendarNow.set(1, calendarEnd.get(1));
        }
        if (calendarEnd.get(2) != calendarNow.get(2)) {
            iRateMonths += calendarEnd.get(2) - calendarNow.get(2);
            calendarNow.set(2, calendarEnd.get(2));
        }
        if (iRateMonths > 0 && calendarNow.get(5) > calendarEnd.get(5)) {
            --iRateMonths;
        }
        return iRateMonths;
    }

    public static Calendar calculateEndDate(Calendar a_startDate, int a_duration, int a_calendarFieldUnit) {
        Calendar now = (Calendar)a_startDate.clone();
        if (a_calendarFieldUnit == 5 || a_calendarFieldUnit == 5) {
            now.add(5, a_duration);
        } else if (a_calendarFieldUnit == 3) {
            now.add(3, a_duration);
            now.add(5, -1);
        } else if (a_calendarFieldUnit == 2) {
            now.add(2, a_duration);
            now.add(5, -1);
        } else if (a_calendarFieldUnit == 1) {
            now.add(1, a_duration);
            now.add(5, -1);
        } else {
            return null;
        }
        now.set(11, 23);
        now.set(12, 59);
        now.set(13, 59);
        now.set(14, 0);
        return now;
    }

    public boolean isLastMonthOfRate(Timestamp a_tNow) {
        return XMLBalance.isLastMonthOfRate(this.getFlatEnddate(), a_tNow, this.getStartDate());
    }

    public static boolean isLastMonthOfRate(Timestamp a_tEnd, Timestamp a_tNow, Timestamp a_tStart) {
        if (a_tEnd.getTime() < a_tNow.getTime()) {
            return false;
        }
        return XMLBalance.isSameMonthlyPeriod(a_tNow, a_tEnd, a_tStart, false);
    }

    public static boolean isLastMonthOfRate(Calendar a_calendarEnd, Calendar a_calendarNow, Calendar a_calendarStart) {
        if (a_calendarEnd.getTime().getTime() < a_calendarNow.getTime().getTime()) {
            return false;
        }
        Calendar calendarEnd = (Calendar)a_calendarEnd.clone();
        Calendar calendarNow = (Calendar)a_calendarNow.clone();
        Calendar calendarStart = (Calendar)a_calendarStart.clone();
        return XMLBalance.isSameMonthlyPeriod(calendarNow, calendarEnd, calendarStart, false);
    }

    public class MonthlyOverusage {
        public double m_dFactor;
        public Timestamp m_tEndOfCurrentPeriod;
        public long m_lAdditionalTraffic;
    }
}

