/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class WindowsRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static Class ms_windowsPreferencesClass;
    private static Method ms_openKeyMethod;
    private static Method ms_queryValueMethod;
    private static Method ms_closeKeyMethod;
    private Vector m_vecHandles = new Vector();
    private boolean m_bClosed = false;
    static /* synthetic */ Class array$B;

    public WindowsRegistry(int a_handleHome, String a_path, int a_securityMask) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(a_path, "\\/");
        while (tokenizer.hasMoreTokens()) {
            String strCurrent = tokenizer.nextToken();
            try {
                a_handleHome = WindowsRegistry.openKey(a_handleHome, strCurrent, a_securityMask);
                this.m_vecHandles.addElement(new Integer(a_handleHome));
            }
            catch (Exception a_e) {
                this.close();
                throw a_e;
            }
        }
    }

    public synchronized String read(String a_key) {
        if (this.isClosed()) {
            return null;
        }
        return WindowsRegistry.queryValue((Integer)this.m_vecHandles.lastElement(), a_key);
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public synchronized void close() {
        for (int i = this.m_vecHandles.size() - 1; i >= 0; --i) {
            WindowsRegistry.closeKey((Integer)this.m_vecHandles.elementAt(i));
        }
        this.m_bClosed = true;
    }

    private static int openKey(int a_hKey, String a_subKey, int a_securityMask) throws Exception {
        try {
            int[] result = (int[])ms_openKeyMethod.invoke(null, new Integer(a_hKey), (a_subKey + "\u0000").getBytes(), new Integer(a_securityMask));
            if (result != null && result[1] == 0) {
                return result[0];
            }
            if (result != null) {
                if (result[1] == 2) {
                    throw new FileNotFoundException(a_subKey);
                }
                if (result[1] == 5) {
                    throw new SecurityException(a_subKey);
                }
                throw new Exception("Registry error (" + result[1] + "): " + a_subKey);
            }
        }
        catch (InvocationTargetException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        catch (IllegalAccessException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        return -1;
    }

    private static String queryValue(int a_hKey, String a_valueName) {
        try {
            byte[] b = (byte[])ms_queryValueMethod.invoke(null, new Integer(a_hKey), (a_valueName + "\u0000").getBytes());
            if (b != null) {
                String s = new String(b);
                if (s.charAt(s.length() - 1) == '\u0000') {
                    s = s.substring(0, s.length() - 1);
                }
                return s;
            }
        }
        catch (InvocationTargetException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        catch (IllegalAccessException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        return null;
    }

    private static int closeKey(int a_hKey) {
        try {
            Integer i = (Integer)ms_closeKeyMethod.invoke(null, new Integer(a_hKey));
            if (i != null) {
                return i;
            }
        }
        catch (InvocationTargetException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        catch (IllegalAccessException ex) {
            LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", ex);
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("os.name", "").toLowerCase().indexOf("win") != -1) {
            try {
                Class<?> accessibleObjectClass = Class.forName("java.lang.reflect.AccessibleObject");
                Method setAccessibleMethod = accessibleObjectClass.getMethod("setAccessible", Boolean.TYPE);
                ms_windowsPreferencesClass = Class.forName("java.util.prefs.WindowsPreferences");
                ms_openKeyMethod = ms_windowsPreferencesClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, array$B == null ? (array$B = WindowsRegistry.class$("[B")) : array$B, Integer.TYPE);
                ms_queryValueMethod = ms_windowsPreferencesClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, array$B == null ? (array$B = WindowsRegistry.class$("[B")) : array$B);
                ms_closeKeyMethod = ms_windowsPreferencesClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                setAccessibleMethod.invoke((Object)ms_openKeyMethod, Boolean.TRUE);
                setAccessibleMethod.invoke((Object)ms_queryValueMethod, Boolean.TRUE);
                setAccessibleMethod.invoke((Object)ms_closeKeyMethod, Boolean.TRUE);
            }
            catch (Throwable t) {
                LogHolder.log(2, LogType.GUI, "Error while accessing windows registry.", t);
            }
        }
    }
}

