/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.BusyFlag;
import anon.util.CondVar;
import java.util.Vector;

public final class ThreadPool {
    private Vector objects;
    private int nObjects = 0;
    private int nMaxThreads = 0;
    private CondVar cvAvailable;
    private CondVar cvEmpty;
    private BusyFlag cvFlag = new BusyFlag();
    private ThreadPoolThread[] poolThreads;
    private boolean terminated = false;

    public ThreadPool(String name, int m_maxConcurrentThreads) {
        this(name, m_maxConcurrentThreads, 5);
    }

    public ThreadPool(String name, int n, int priority) {
        this.cvAvailable = new CondVar(this.cvFlag);
        this.cvEmpty = new CondVar(this.cvFlag);
        this.objects = new Vector();
        this.nMaxThreads = n;
        this.poolThreads = new ThreadPoolThread[n];
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < n; ++i) {
            this.poolThreads[i] = new ThreadPoolThread(this, i, name);
            this.poolThreads[i].setPriority(priority);
            this.poolThreads[i].setDaemon(true);
            this.poolThreads[i].start();
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.poolThreads.length; ++i) {
            this.poolThreads[i].shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Runnable target, Object lock) {
        try {
            this.cvFlag.getBusyFlag();
            if (this.terminated) {
                throw new IllegalStateException("Thread pool has shutdown");
            }
            this.objects.addElement(new ThreadPoolRequest(target, lock));
            ++this.nObjects;
            this.cvAvailable.cvSignal();
            while (this.nObjects > this.nMaxThreads) {
                try {
                    this.cvEmpty.cvWait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object var5_4 = null;
            this.cvFlag.freeBusyFlag();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cvFlag.freeBusyFlag();
            throw throwable;
        }
    }

    public void addRequest(Runnable target) {
        this.add(target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestAndWait(Runnable target) throws InterruptedException {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            this.add(target, lock);
            lock.wait();
        }
    }

    private final class ThreadPoolThread
    extends Thread {
        ThreadPool parent;
        boolean shouldRun = true;

        ThreadPoolThread(ThreadPool parent, int i, String name) {
            super(name + " - ThreadPoolThread " + i);
            this.parent = parent;
        }

        public void shutdown() {
            this.shouldRun = false;
            while (this.isAlive()) {
                this.interrupt();
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPoolRequest obj = null;
            while (this.shouldRun) {
                Object var6_8;
                Object var4_7;
                try {
                    this.parent.cvFlag.getBusyFlag();
                    while (obj == null && this.shouldRun) {
                        try {
                            obj = (ThreadPoolRequest)this.parent.objects.elementAt(0);
                            this.parent.objects.removeElementAt(0);
                        }
                        catch (ArrayIndexOutOfBoundsException aiobe) {
                            obj = null;
                        }
                        catch (ClassCastException cce) {
                            obj = null;
                        }
                        if (obj != null) continue;
                        try {
                            this.parent.cvAvailable.cvWait();
                        }
                        catch (InterruptedException ie) {
                            var4_7 = null;
                            this.parent.cvFlag.freeBusyFlag();
                            return;
                        }
                    }
                    var4_7 = null;
                    this.parent.cvFlag.freeBusyFlag();
                }
                catch (Throwable throwable) {
                    var4_7 = null;
                    this.parent.cvFlag.freeBusyFlag();
                    throw throwable;
                }
                if (!this.shouldRun) {
                    return;
                }
                try {
                    obj.target.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.parent.cvFlag.getBusyFlag();
                    ThreadPool.this.nObjects--;
                    if (ThreadPool.this.nObjects < ThreadPool.this.nMaxThreads) {
                        this.parent.cvEmpty.cvSignal();
                    }
                    var6_8 = null;
                    this.parent.cvFlag.freeBusyFlag();
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    this.parent.cvFlag.freeBusyFlag();
                    throw throwable;
                }
                if (obj.lock != null) {
                    Object object = obj.lock;
                    synchronized (object) {
                        obj.lock.notify();
                    }
                }
                obj = null;
            }
        }
    }

    private final class ThreadPoolRequest {
        Runnable target;
        Object lock;

        ThreadPoolRequest(Runnable t, Object l) {
            this.target = t;
            this.lock = l;
        }
    }
}

