/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.crypto.AbstractX509AlternativeName;
import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.ILocationSettings;
import gui.JAPHelpContext;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.IDialogOptions;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import logging.LogHolder;
import logging.LogType;

public class JAPDialog
implements Accessible,
WindowConstants,
RootPaneContainer,
MenuContainer,
ImageObserver,
IDialogOptions,
ILocationSettings {
    public static final String XML_ATTR_OPTIMIZED_FORMAT = "dialogOptFormat";
    public static final int FORMAT_GOLDEN_RATIO_PHI = 0;
    public static final int FORMAT_DEFAULT_SCREEN = 1;
    public static final int FORMAT_WIDE_SCREEN = 2;
    private static String ms_strGlobalTitle;
    private static final double[] FORMATS;
    public static final String MSG_ERROR_UNKNOWN;
    public static final String MSG_TITLE_INFO;
    public static final String MSG_TITLE_CONFIRMATION;
    public static final String MSG_TITLE_WARNING;
    public static final String MSG_TITLE_ERROR;
    public static final String MSG_ERROR_UNDISPLAYABLE;
    public static final String MSG_BTN_PROCEED;
    public static final String MSG_BTN_RETRY;
    private static final int NUMBER_OF_HEURISTIC_ITERATIONS = 6;
    private static int m_optimizedFormat;
    private static Hashtable ms_registeredDialogs;
    private static boolean ms_bConsoleOnly;
    private boolean m_bLocationSetManually = false;
    private boolean m_bModal;
    private boolean m_bBlockParentWindow = false;
    private int m_defaultCloseOperation;
    private Vector m_windowListeners = new Vector();
    private Vector m_componentListeners = new Vector();
    private DialogWindowAdapter m_dialogWindowAdapter;
    private boolean m_bForceApplicationModality;
    private boolean m_bDisposed = false;
    private GUIUtils.WindowDocker m_docker;
    private final Object SYNC_DOCK = new Object();
    private JDialog m_internalDialog;
    private Component m_parentComponent;
    private Window m_parentWindow;
    private boolean m_bOnTop = false;
    static /* synthetic */ Class class$gui$dialog$JAPDialog;
    static /* synthetic */ Class class$java$awt$event$WindowListener;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$swing$JDialog;
    static /* synthetic */ Class class$gui$dialog$JAPDialog$ILinkedInformation;
    static /* synthetic */ Class class$gui$dialog$JAPDialog$LinkedCheckBox;
    static /* synthetic */ Class class$java$awt$Container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsoleOnly(boolean a_bConsoleOnly) {
        ms_bConsoleOnly = a_bConsoleOnly;
        if (ms_bConsoleOnly) {
            Enumeration<Object> enumCurrentDialogs;
            Vector currentDialogs;
            Hashtable hashtable = ms_registeredDialogs;
            synchronized (hashtable) {
                currentDialogs = new Vector(ms_registeredDialogs.size());
                enumCurrentDialogs = ms_registeredDialogs.elements();
                while (enumCurrentDialogs.hasMoreElements()) {
                    currentDialogs.addElement(enumCurrentDialogs.nextElement());
                }
            }
            enumCurrentDialogs = currentDialogs.elements();
            while (enumCurrentDialogs.hasMoreElements()) {
                ((JAPDialog)enumCurrentDialogs.nextElement()).dispose();
            }
            currentDialogs.removeAllElements();
        }
    }

    public static boolean isConsoleOnly() {
        return ms_bConsoleOnly;
    }

    public JAPDialog(Component a_parentComponent, String a_strTitle, boolean a_bModal) {
        this(a_parentComponent, a_strTitle, a_bModal, false);
    }

    public JAPDialog(Component a_parentComponent, String a_strTitle) {
        this(a_parentComponent, a_strTitle, true);
    }

    public JAPDialog(JAPDialog a_parentDialog, String a_strTitle, boolean a_bModal) {
        this(JAPDialog.getInternalDialog(a_parentDialog), a_strTitle, a_bModal);
    }

    public JAPDialog(JAPDialog a_parentDialog, String a_strTitle) {
        this(JAPDialog.getInternalDialog(a_parentDialog), a_strTitle);
    }

    private JAPDialog(Component a_parentComponent, String a_strTitle, boolean a_bModal, boolean a_bForceApplicationModality) {
        EventListener[] listeners;
        this.m_parentComponent = a_parentComponent;
        this.m_bForceApplicationModality = a_bForceApplicationModality;
        this.m_internalDialog = new JOptionPane().createDialog(a_parentComponent, JAPDialog.checkGlobalTitle(a_strTitle));
        if (this.m_parentComponent == null) {
            this.m_parentComponent = this.m_internalDialog.getParent();
        }
        this.m_internalDialog.getContentPane().removeAll();
        this.m_internalDialog.setResizable(true);
        this.m_internalDialog.setModal(false);
        this.m_internalDialog.setDefaultCloseOperation(0);
        this.setDefaultCloseOperation(2);
        try {
            listeners = (EventListener[])(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = JAPDialog.class$("javax.swing.JDialog")) : class$javax$swing$JDialog).getMethod("getListeners", class$java$lang$Class == null ? (class$java$lang$Class = JAPDialog.class$("java.lang.Class")) : class$java$lang$Class).invoke((Object)this.m_internalDialog, class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = JAPDialog.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener);
        }
        catch (Exception a_e) {
            listeners = null;
        }
        for (int i = 0; listeners != null && i < listeners.length; ++i) {
            this.m_internalDialog.removeWindowListener((WindowListener)listeners[i]);
        }
        this.m_dialogWindowAdapter = new DialogWindowAdapter();
        this.m_internalDialog.addWindowListener(this.m_dialogWindowAdapter);
        this.m_parentWindow = GUIUtils.getParentWindow(this.getParentComponent());
        this.setModal(a_bModal);
        ms_registeredDialogs.put(this, this);
        final JAPDialog thisDialog = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent a_event) {
                ms_registeredDialogs.remove(thisDialog);
                thisDialog.removeWindowListener(this);
            }
        });
    }

    public static void setOptimizedFormat(int a_optimizedFormat) {
        if (a_optimizedFormat < 0 || a_optimizedFormat >= FORMATS.length) {
            a_optimizedFormat = FORMATS.length - 1;
        }
        m_optimizedFormat = a_optimizedFormat;
    }

    public static int getOptimizedFormat() {
        return m_optimizedFormat;
    }

    public static double getOptimizedFormatInternal(int a_format) {
        if (a_format < 0 || a_format >= FORMATS.length) {
            a_format = FORMATS.length - 1;
        }
        return FORMATS[a_format];
    }

    public static double getOptimizedFormatDelta(Window a_window) {
        return (double)a_window.getSize().height * JAPDialog.getOptimizedFormatInternal(m_optimizedFormat) - (double)a_window.getSize().width;
    }

    public static double getOptimizedFormatDelta(JAPDialog a_dialog) {
        return (double)a_dialog.getSize().height * JAPDialog.getOptimizedFormatInternal(m_optimizedFormat) - (double)a_dialog.getSize().width;
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message) {
        JAPDialog.showMessageDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_linkedInformation);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, JAPMessages.getString(MSG_TITLE_INFO), (Icon)null);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, JAPMessages.getString(MSG_TITLE_INFO), (Icon)null, a_linkedInformation);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, String a_title) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_linkedInformation);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, String a_title) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, a_title, (Icon)null);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, a_title, null, a_linkedInformation);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, Icon a_icon) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_icon);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, Icon a_icon, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_icon, a_linkedInformation);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, Icon a_icon) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, JAPMessages.getString(MSG_TITLE_INFO), a_icon);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, Icon a_icon, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, JAPMessages.getString(MSG_TITLE_INFO), a_icon, a_linkedInformation);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, String a_title, Icon a_icon) {
        JAPDialog.showMessageDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_icon);
    }

    public static void showMessageDialog(JAPDialog a_parentDialog, String a_message, String a_title, Icon a_icon, ILinkedInformation a_linkedInformation) {
        JAPDialog.showMessageDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_icon, a_linkedInformation);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, String a_title, Icon a_icon) {
        JAPDialog.showMessageDialog(a_parentComponent, a_message, a_title, a_icon, null);
    }

    public static void showMessageDialog(Component a_parentComponent, String a_message, String a_title, Icon a_icon, ILinkedInformation a_linkedInformation) {
        if (a_title == null) {
            a_title = JAPMessages.getString(MSG_TITLE_CONFIRMATION);
        }
        JAPDialog.showConfirmDialog(a_parentComponent, a_message, JAPDialog.checkGlobalTitle(a_title), -1, 1, a_icon, a_linkedInformation);
    }

    public static void showWarningDialog(JAPDialog a_parentDialog, String a_message) {
        JAPDialog.showWarningDialog(a_parentDialog, a_message, null, null);
    }

    public static void showWarningDialog(Component a_parentComponent, String a_message) {
        JAPDialog.showWarningDialog(a_parentComponent, a_message, null, null);
    }

    public static void showWarningDialog(JAPDialog a_parentDialog, String a_message, String a_title) {
        JAPDialog.showWarningDialog(a_parentDialog, a_message, a_title, null);
    }

    public static void showWarningDialog(Component a_parentComponent, String a_message, String a_title) {
        JAPDialog.showWarningDialog(a_parentComponent, a_message, a_title, null);
    }

    public static void showWarningDialog(JAPDialog a_parentDialog, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        JAPDialog.showWarningDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_linkedInformation);
    }

    public static void showWarningDialog(JAPDialog a_parentDialog, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showWarningDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, null, a_linkedInformation);
    }

    public static void showWarningDialog(Component a_parentComponent, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showWarningDialog(a_parentComponent, a_message, null, a_linkedInformation);
    }

    public static void showWarningDialog(Component a_parentComponent, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        if (a_title == null) {
            a_title = JAPMessages.getString(MSG_TITLE_WARNING);
        }
        JAPDialog.showConfirmDialog(a_parentComponent, a_message, JAPDialog.checkGlobalTitle(a_title), -1, 2, null, a_linkedInformation);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, String a_title, int a_optionType, int a_messageType, Icon a_icon) {
        return JAPDialog.showConfirmDialog(a_parentDialog, a_message, a_title, a_optionType, a_messageType, a_icon, null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, int a_optionType, int a_messageType, Icon a_icon) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_title, a_optionType, a_messageType, a_icon, null);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, String a_title, int a_optionType, int a_messageType, Icon a_icon, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_optionType, a_messageType, a_icon, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, int a_optionType, int a_messageType, Icon a_icon, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_title, new Options(a_optionType), a_messageType, a_icon, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, Options a_options, int a_messageType) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, (String)null, a_options, a_messageType, (Icon)null, (ILinkedInformation)null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, Options a_options, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, (String)null, a_options, a_messageType, (Icon)null, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_strTitle, Options a_options, int a_messageType) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_strTitle, a_options, a_messageType, (Icon)null, null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, Options a_options, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_title, a_options, a_messageType, null, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, final Options a_options, int a_messageType, Icon a_icon, ILinkedInformation a_linkedInformation) {
        int currentWidth;
        JComponent linkLabel;
        JAPHtmlMultiLineLabel label;
        JAPDialog dialog;
        DialogContentPane dialogContentPane;
        String strLinkedInformation;
        JAPHelpContext.IHelpContext helpContext = null;
        boolean bForceApplicationModality = false;
        boolean bOnTop = false;
        boolean bModal = true;
        boolean bIsCloseWindowActive = true;
        Vector<String> vecOptions = new Vector<String>();
        String strToolTip = null;
        if (ms_bConsoleOnly) {
            LogHolder.log(1, LogType.GUI, a_message);
            return Integer.MIN_VALUE;
        }
        if (a_message == null) {
            a_message = "";
        }
        String message = a_message = JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(a_message);
        if (a_title == null) {
            a_title = JAPMessages.getString(MSG_TITLE_CONFIRMATION);
        }
        a_title = JAPDialog.checkGlobalTitle(a_title);
        if (a_linkedInformation != null) {
            bForceApplicationModality = a_linkedInformation.isApplicationModalityForced();
            bOnTop = a_linkedInformation.isOnTop();
            bModal = a_linkedInformation.isModal();
            bIsCloseWindowActive = a_linkedInformation.isCloseWindowActive();
            strToolTip = a_linkedInformation.getTooltipText();
            if (a_linkedInformation instanceof JAPHelpContext.IHelpContext) {
                helpContext = (JAPHelpContext.IHelpContext)((Object)a_linkedInformation);
                if (a_linkedInformation.getType() == 0) {
                    a_linkedInformation = null;
                }
            }
        }
        if (a_linkedInformation != null && a_linkedInformation.getMessage() != null && a_linkedInformation.getMessage().trim().length() > 0) {
            strLinkedInformation = JAPHtmlMultiLineLabel.removeTagsAndNewLines(a_linkedInformation.getMessage());
            if (a_linkedInformation.getType() != 3 && a_linkedInformation.getType() != 4) {
                message = message + "<br><a href=\"\">" + strLinkedInformation + "</a>";
            }
        } else {
            strLinkedInformation = null;
        }
        if ((dialogContentPane = new DialogContentPane(dialog = new JAPDialog(a_parentComponent, a_title, true, bForceApplicationModality), new DialogContentPane.Layout(null, a_messageType, a_icon), new DialogContentPaneOptions(a_options.getOptionType(), helpContext, a_options.getUpdateCallbackHandler())){

            public String getButtonYesOKText() {
                if (a_options == null) {
                    return null;
                }
                try {
                    return a_options.getYesOKText();
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public String getButtonNoText() {
                if (a_options == null) {
                    return null;
                }
                try {
                    return a_options.getNoText();
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public String getButtonCancelText() {
                if (a_options == null) {
                    return null;
                }
                try {
                    return a_options.getCancelText();
                }
                catch (Throwable t) {
                    return null;
                }
            }
        }).getButtonHelp() != null) {
            vecOptions.addElement(dialogContentPane.getButtonHelp().getText());
        }
        String text = dialogContentPane.getButtonYesOKText();
        if (dialogContentPane.getButtonYesOK() != null && text != null) {
            vecOptions.addElement(text);
        }
        text = dialogContentPane.getButtonCancelText();
        if (dialogContentPane.getButtonCancel() != null && text != null) {
            vecOptions.addElement(text);
        }
        text = dialogContentPane.getButtonNoText();
        if (dialogContentPane.getButtonNo() != null && text != null) {
            vecOptions.addElement(text);
        }
        if (!a_options.isDrawFocusEnabled()) {
            dialogContentPane.getButtonNo().setFocusPainted(false);
            dialogContentPane.getButtonYesOK().setFocusPainted(false);
            dialogContentPane.getButtonCancel().setFocusPainted(false);
        }
        dialogContentPane.setDefaultButtonOperation(2);
        dialogContentPane.updateDialog();
        dialog.pack();
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JAPHtmlMultiLineLabel runLabel = new JAPHtmlMultiLineLabel("Text");
                        runLabel.setText(runLabel.getText());
                        runLabel.revalidate();
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        try {
            label = new JAPHtmlMultiLineLabel("Text");
        }
        catch (NullPointerException a_e) {
            if (Thread.currentThread().isInterrupted()) {
                return Integer.MIN_VALUE;
            }
            throw a_e;
        }
        if (label.getPreferredSize().width == 0 || label.getPreferredSize().height == 0) {
            LogHolder.log(0, LogType.GUI, "Dialog label size is invalid! This dialog might not show any label!");
        }
        try {
            label = new JAPHtmlMultiLineLabel(message);
            label.setFontStyle(0);
        }
        catch (NullPointerException a_e) {
            if (Thread.currentThread().isInterrupted()) {
                return Integer.MIN_VALUE;
            }
            throw a_e;
        }
        StringTokenizer tokenizer = new StringTokenizer(label.getHTMLDocumentText());
        int iMaxWordLength = 0;
        String strWordMaxLength = null;
        while (tokenizer.hasMoreTokens()) {
            String strCurrentWord = tokenizer.nextToken();
            if (strCurrentWord.length() <= iMaxWordLength) continue;
            iMaxWordLength = strCurrentWord.length();
            strWordMaxLength = strCurrentWord;
        }
        if (strLinkedInformation != null && strLinkedInformation.length() > iMaxWordLength) {
            iMaxWordLength = strLinkedInformation.length();
            strWordMaxLength = strLinkedInformation;
        }
        PreferredWidthBoxPanel dummyBox = new PreferredWidthBoxPanel();
        if (strLinkedInformation != null && (a_linkedInformation.getType() == 3 || a_linkedInformation.getType() == 4)) {
            linkLabel = new JCheckBox("Text");
            linkLabel.setFont(label.getFont());
            dummyBox.add(linkLabel);
        }
        dummyBox.add(label);
        dialogContentPane.setContentPane(dummyBox);
        dialogContentPane.updateDialog();
        JComponent contentPane = (JComponent)dialog.getContentPane();
        Dimension bestDimension = null;
        Icon icon = a_icon;
        if (icon == null) {
            icon = DialogContentPane.getMessageIcon(a_messageType);
        }
        Object[] options = new String[vecOptions.size()];
        for (int i = 0; i < options.length; ++i) {
            options[i] = vecOptions.elementAt(i).toString();
        }
        JDialog tempDialog = new JOptionPane(new JAPHtmlMultiLineLabel(strWordMaxLength), a_messageType, a_options.getOptionType(), icon, options).createDialog(a_parentComponent, a_title);
        tempDialog.pack();
        Dimension minSize = new Dimension(tempDialog.getContentPane().getSize());
        tempDialog.dispose();
        tempDialog = null;
        minSize.setSize(Math.max(minSize.width, dialog.getSize().width), minSize.height);
        int maxWidth = 0;
        try {
            Window parentWindow = GUIUtils.getParentWindow(a_parentComponent);
            if (parentWindow == null) {
                return Integer.MIN_VALUE;
            }
            maxWidth = parentWindow.getSize().width;
        }
        catch (NullPointerException a_e) {
            if (Thread.currentThread().isInterrupted()) {
                return Integer.MIN_VALUE;
            }
            throw a_e;
        }
        if (maxWidth < minSize.width * 4) {
            maxWidth = minSize.width * 4;
        }
        maxWidth = Math.min(contentPane.getWidth(), maxWidth);
        double bestDelta = Double.MAX_VALUE;
        int bestWidth = currentWidth = Math.min(500, contentPane.getWidth());
        int failed = 0;
        int minLabelWidth = Math.max(label.getMinimumSize().width, new JAPHtmlMultiLineLabel((String)strWordMaxLength).getPreferredSize().width);
        boolean bAlgorithmFailed = true;
        for (int i = 0; i < 6; ++i) {
            dummyBox = new PreferredWidthBoxPanel();
            dummyBox.add(contentPane);
            dummyBox.setPreferredWidth(currentWidth);
            dialog.setContentPane(dummyBox);
            dialog.pack();
            label.setPreferredWidth(label.getWidth());
            dialog.pack();
            if (dummyBox.getHeight() < minSize.height) {
                LogHolder.log(5, LogType.GUI, "Dialog height was too small.");
                dummyBox.setPreferredHeigth(minSize.height);
                dialog.pack();
            }
            currentWidth = dummyBox.getWidth();
            double currentDelta = JAPDialog.getOptimizedFormatDelta(dialog);
            if (Math.abs(currentDelta) < Math.abs(bestDelta) && (i == 0 || label.getSize().width >= minLabelWidth)) {
                bestDimension = new Dimension(dummyBox.getSize());
                bestDelta = currentDelta;
                bestWidth = currentWidth;
                currentWidth = (int)((double)currentWidth + bestDelta / 2.0);
                if (label.getSize().width < minLabelWidth) {
                    ++failed;
                } else {
                    bAlgorithmFailed = false;
                    failed = 0;
                }
            } else {
                currentWidth = label.getSize().width < minLabelWidth ? (int)((double)currentWidth + ((double)(minLabelWidth - label.getSize().width + failed) + 1.0)) : bestWidth + (int)(bestDelta / (3.0 * ((double)failed + 1.0)));
                ++failed;
            }
            currentWidth = Math.max(currentWidth, minSize.width);
            if (currentWidth == bestWidth) break;
        }
        if (bAlgorithmFailed) {
            LogHolder.log(3, LogType.GUI, "Auto-formatting of dialog failed!");
            bestDimension = new Dimension(dummyBox.getSize());
        }
        dummyBox = new PreferredWidthBoxPanel();
        try {
            label = new JAPHtmlMultiLineLabel("<font color=#000000>" + a_message + "</font>");
            label.setFontStyle(0);
        }
        catch (NullPointerException a_e) {
            if (Thread.currentThread().isInterrupted()) {
                return Integer.MIN_VALUE;
            }
            throw a_e;
        }
        dummyBox.add(label);
        linkLabel = null;
        if (strLinkedInformation != null) {
            if (a_linkedInformation.getType() == 2) {
                LogHolder.log(3, LogType.GUI, "The selectable link feature does not format properly on Java 7!!");
                JTextPane textPane = GUIUtils.createSelectableAndResizeableLabel(dummyBox);
                textPane.setText(strLinkedInformation);
                textPane.setFont(label.getFont());
                textPane.setMargin(new Insets(0, 0, 0, 0));
                textPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
                textPane.setForeground(Color.blue);
                textPane.setCursor(Cursor.getPredefinedCursor(12));
                linkLabel = textPane;
                linkLabel.addMouseListener(new LinkedInformationClickListener(a_linkedInformation));
            } else if (a_linkedInformation.getType() == 3 || a_linkedInformation.getType() == 4) {
                linkLabel = new JCheckBox(strLinkedInformation, a_linkedInformation.getType() == 3);
                linkLabel.setFont(label.getFont());
                ((AbstractButton)linkLabel).addItemListener(new LinkedInformationClickListener(a_linkedInformation));
            } else {
                linkLabel = new JAPHtmlMultiLineLabel("<a href=\"\">" + strLinkedInformation + "</a>");
                linkLabel.addMouseListener(new LinkedInformationClickListener(a_linkedInformation));
                linkLabel.setCursor(Cursor.getPredefinedCursor(12));
            }
            linkLabel.setToolTipText(strToolTip);
            dummyBox.add(linkLabel);
        }
        dialogContentPane.setContentPane(dummyBox);
        dialogContentPane.setDefaultButton(a_options.getDefaultButton());
        dialogContentPane.updateDialog();
        ((JComponent)dialog.getContentPane()).setPreferredSize(bestDimension);
        dialog.pack();
        if (bestDelta != JAPDialog.getOptimizedFormatDelta(dialog)) {
            LogHolder.log(3, LogType.GUI, "Calculated dialog size differs from real size!");
        }
        LogHolder.log(5, LogType.GUI, "Dialog golden ratio delta: " + JAPDialog.getOptimizedFormatDelta(dialog));
        dialog.setResizable(false);
        if (bIsCloseWindowActive) {
            dialog.setDefaultCloseOperation(2);
        } else {
            dialog.setDefaultCloseOperation(0);
        }
        dialog.addWindowListener(new SimpleDialogButtonFocusWindowAdapter(dialogContentPane));
        dialog.m_bOnTop = bOnTop;
        if (!bModal) {
            dialog.setModal(false);
        }
        dialog.setVisible(true);
        dialog = null;
        return dialogContentPane.getButtonValue();
    }

    public static boolean showYesNoDialog(JAPDialog a_parentDialog, String a_message) {
        return JAPDialog.showYesNoDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message);
    }

    public static boolean showYesNoDialog(JAPDialog a_parentDialog, String a_message, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showYesNoDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_linkedInformation);
    }

    public static boolean showYesNoDialog(Component a_parentComponent, String a_message) {
        return JAPDialog.showYesNoDialog(a_parentComponent, a_message, (String)null);
    }

    public static boolean showYesNoDialog(Component a_parentComponent, String a_message, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showYesNoDialog(a_parentComponent, a_message, null, a_linkedInformation);
    }

    public static boolean showYesNoDialog(JAPDialog a_parentDialog, String a_message, String a_title) {
        return JAPDialog.showYesNoDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title);
    }

    public static boolean showYesNoDialog(JAPDialog a_parentDialog, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showYesNoDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_linkedInformation);
    }

    public static boolean showYesNoDialog(Component a_parentComponent, String a_message, String a_title) {
        return JAPDialog.showYesNoDialog(a_parentComponent, a_message, a_title, null);
    }

    public static boolean showYesNoDialog(Component a_parentComponent, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        int response;
        if (a_title == null) {
            a_title = JAPMessages.getString(MSG_TITLE_CONFIRMATION);
        }
        return 0 == (response = JAPDialog.showConfirmDialog(a_parentComponent, a_message, JAPDialog.checkGlobalTitle(a_title), 0, 3, null, a_linkedInformation));
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, int a_optionType, int a_messageType, Icon a_icon) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, null, a_optionType, a_messageType, a_icon, null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, int a_optionType, int a_messageType, Icon a_icon) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, null, a_optionType, a_messageType, a_icon, null);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, int a_optionType, int a_messageType) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, null, a_optionType, a_messageType, null, null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, int a_optionType, int a_messageType) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, null, a_optionType, a_messageType, null, null);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, int a_optionType, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, null, a_optionType, a_messageType, null, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, int a_optionType, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, null, a_optionType, a_messageType, null, a_linkedInformation);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, String a_title, int a_optionType, int a_messageType) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_optionType, a_messageType, null, null);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, int a_optionType, int a_messageType) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_title, a_optionType, a_messageType, null, null);
    }

    public static int showConfirmDialog(JAPDialog a_parentDialog, String a_message, String a_title, int a_optionType, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_optionType, a_messageType, null, a_linkedInformation);
    }

    public static int showConfirmDialog(Component a_parentComponent, String a_message, String a_title, int a_optionType, int a_messageType, ILinkedInformation a_linkedInformation) {
        return JAPDialog.showConfirmDialog(a_parentComponent, a_message, a_title, a_optionType, a_messageType, null, a_linkedInformation);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, String a_message) {
        JAPDialog.showErrorDialog(a_parentDialog, a_message, (Throwable)null);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, String a_title, ILinkedInformation a_linkedInformation) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, a_title, null, a_linkedInformation);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, null, null, a_linkedInformation);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, (Throwable)null);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, String a_title) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, a_title, null, null);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, String a_message, String a_title) {
        JAPDialog.showErrorDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, null, null);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, String a_message, ILinkedInformation a_linkedInformation) {
        JAPDialog.showErrorDialog(JAPDialog.getInternalDialog(a_parentDialog), a_message, null, null, null);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, Throwable a_throwable) {
        JAPDialog.showErrorDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), null, null, a_throwable);
    }

    public static void showErrorDialog(Component a_parentComponent, Throwable a_throwable) {
        JAPDialog.showErrorDialog(a_parentComponent, null, null, a_throwable);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, String a_message, Throwable a_throwable) {
        JAPDialog.showErrorDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_throwable);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, Throwable a_throwable) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, null, a_throwable);
    }

    public static void showErrorDialog(JAPDialog a_parentDialog, String a_message, String a_title, Throwable a_throwable) {
        JAPDialog.showErrorDialog((Component)JAPDialog.getInternalDialog(a_parentDialog), a_message, a_title, a_throwable);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, String a_title, Throwable a_throwable) {
        JAPDialog.showErrorDialog(a_parentComponent, a_message, a_title, a_throwable, null);
    }

    public static void showErrorDialog(Component a_parentComponent, String a_message, String a_title, Throwable a_throwable, ILinkedInformation a_linkedInformation) {
        boolean bPossibleApplicationError = false;
        if ((a_message = JAPDialog.retrieveErrorMessage(a_message, a_throwable)) == null) {
            a_message = JAPMessages.getString(MSG_ERROR_UNKNOWN);
            bPossibleApplicationError = true;
        }
        int a_logType = LogType.GUI;
        LogHolder.log(3, a_logType, a_message, 1);
        if (a_throwable != null) {
            if (bPossibleApplicationError) {
                LogHolder.log(3, a_logType, a_throwable);
            } else {
                LogHolder.log(6, a_logType, a_throwable);
            }
        }
        try {
            if (a_title == null) {
                a_title = JAPMessages.getString(MSG_TITLE_ERROR);
            }
            JAPDialog.showConfirmDialog(a_parentComponent, a_message, JAPDialog.checkGlobalTitle(a_title), -1, 0, null, a_linkedInformation);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.GUI, JAPMessages.getString(MSG_ERROR_UNDISPLAYABLE));
            LogHolder.log(2, LogType.GUI, e);
        }
    }

    public static String retrieveErrorMessage(String a_message, Throwable a_throwable) {
        if (a_message == null || a_message.trim().length() == 0) {
            if (a_throwable == null || a_throwable.getMessage() == null) {
                a_message = null;
            } else {
                a_message = a_throwable.getMessage();
                if (a_message == null || a_message.trim().length() == 0) {
                    a_message = null;
                }
            }
        }
        return a_message;
    }

    public Component getGlassPane() {
        return this.m_internalDialog.getGlassPane();
    }

    public JLayeredPane getLayeredPane() {
        return this.m_internalDialog.getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.m_internalDialog.getRootPane();
    }

    public final Container getContentPane() {
        return this.m_internalDialog.getContentPane();
    }

    public void setContentPane(Container a_contentPane) {
        this.m_internalDialog.setContentPane(a_contentPane);
    }

    public void setGlassPane(Component a_glassPane) {
        this.m_internalDialog.setGlassPane(a_glassPane);
    }

    public void setLayeredPane(JLayeredPane a_layeredPane) {
        this.m_internalDialog.setLayeredPane(a_layeredPane);
    }

    public final Component getParentComponent() {
        return this.m_parentComponent;
    }

    public final Window getOwner() {
        return this.m_parentWindow;
    }

    public void setName(String a_name) {
        this.m_internalDialog.setName(a_name);
    }

    public String getName() {
        return this.m_internalDialog.getName();
    }

    public void setEnabled(boolean b) {
        this.m_internalDialog.setEnabled(b);
    }

    public void setAlwaysOnTop(boolean a_bOnTop) {
        if (!this.isVisible()) {
            this.m_bOnTop = a_bOnTop;
        }
    }

    public boolean isVisible() {
        return this.m_internalDialog.isVisible();
    }

    public boolean isDisplayable() {
        return this.m_internalDialog.isDisplayable();
    }

    public void setVisible(boolean a_bVisible) {
        this.setVisible(a_bVisible, true);
    }

    public final void setVisible(boolean a_bVisible, boolean a_bCenterOnParentComponent) {
        if (this.isDisposed()) {
            return;
        }
        if (a_bVisible && !this.m_bLocationSetManually && !this.isVisible()) {
            if (a_bCenterOnParentComponent) {
                GUIUtils.setLocationRelativeTo(this.getParentComponent(), this.m_internalDialog, 0);
            } else {
                GUIUtils.setLocationRelativeTo(this.getOwner(), this.m_internalDialog, 5);
            }
        }
        String dialogName = this.m_internalDialog.getName();
        String newName = null;
        boolean bOwnerOnTop = GUIUtils.isAlwaysOnTop(this.getOwner());
        if (this.m_bOnTop || bOwnerOnTop) {
            GUIUtils.setAlwaysOnTop(this.getOwner(), false);
            this.getOwner().toBack();
            newName = this.getOwner().getName();
            this.m_internalDialog.setName(newName);
            GUIUtils.setAlwaysOnTop(this.m_internalDialog, true);
        }
        this.setVisibleInternal(a_bVisible);
        if (this.m_bOnTop || bOwnerOnTop) {
            String tempName = this.m_internalDialog.getName();
            this.m_internalDialog.setName("JAP " + Double.toString(Math.random()));
            GUIUtils.setAlwaysOnTop(this.getOwner(), bOwnerOnTop);
            GUIUtils.setAlwaysOnTop(this.m_internalDialog, false);
            if (dialogName != null && newName != null && tempName != null && tempName.equals(newName)) {
                this.m_internalDialog.setName(dialogName);
            }
        }
    }

    public static void setGlobalTitle(String a_strTitle) {
        ms_strGlobalTitle = a_strTitle;
    }

    private static String checkGlobalTitle(String a_title) {
        String strGlobalTitle = ms_strGlobalTitle;
        if (strGlobalTitle != null && a_title != null && a_title.indexOf(strGlobalTitle) < 0) {
            a_title = a_title + " - " + strGlobalTitle;
        }
        return a_title;
    }

    public void setTitle(String a_title) {
        this.m_internalDialog.setTitle(a_title);
    }

    public String getTitle() {
        return this.m_internalDialog.getTitle();
    }

    public void setJMenuBar(JMenuBar a_menubar) {
        this.m_internalDialog.setJMenuBar(a_menubar);
    }

    public JMenuBar getJMenuBar() {
        return this.m_internalDialog.getJMenuBar();
    }

    public void toFront() {
        this.m_internalDialog.toFront();
    }

    public void toBack() {
        this.m_internalDialog.toBack();
    }

    public final void setModal(boolean a_bModal) {
        if (this.m_bForceApplicationModality) {
            this.m_bModal = false;
            this.m_internalDialog.setModal(a_bModal);
        } else if (!this.isVisible()) {
            this.m_bModal = a_bModal;
        }
    }

    public boolean isModal() {
        if (this.m_bForceApplicationModality) {
            return this.m_internalDialog.isModal();
        }
        return this.m_bModal;
    }

    public boolean isEnabled() {
        return this.m_internalDialog.isEnabled();
    }

    public boolean isResizable() {
        return this.m_internalDialog.isResizable();
    }

    public boolean isDisposed() {
        return this.m_bDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        this.m_bDisposed = true;
        if (this.m_bBlockParentWindow) {
            this.m_bBlockParentWindow = false;
            this.m_parentWindow.setEnabled(true);
            if (this.m_parentWindow.isVisible()) {
                this.m_parentWindow.setVisible(true);
            }
        }
        this.m_internalDialog.setVisible(false);
        this.m_internalDialog.dispose();
        Object object = this.SYNC_DOCK;
        synchronized (object) {
            if (this.m_docker != null) {
                this.m_docker.finalize();
                this.m_docker = null;
            }
        }
        object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            Enumeration listeners = this.m_windowListeners.elements();
            while (listeners.hasMoreElements()) {
                final WindowListener currrentListener = (WindowListener)listeners.nextElement();
                Thread run = new Thread(new Runnable(){

                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                currrentListener.windowClosed(new WindowEvent(JAPDialog.this.m_internalDialog, 202));
                            }
                        });
                    }
                });
                run.setDaemon(true);
                run.start();
            }
            this.m_windowListeners.removeAllElements();
            listeners = ((Vector)this.m_componentListeners.clone()).elements();
            while (listeners.hasMoreElements()) {
                this.removeComponentListener((ComponentListener)listeners.nextElement());
            }
            this.m_componentListeners.removeAllElements();
            this.m_internalDialog.removeWindowListener(this.m_dialogWindowAdapter);
            this.m_dialogWindowAdapter = null;
            this.m_internalDialog.getContentPane().removeAll();
            this.m_internalDialog.getRootPane().removeAll();
            this.m_internalDialog.getLayeredPane().removeAll();
            this.m_internalDialog.getTreeLock().notifyAll();
        }
    }

    public void validate() {
        this.m_internalDialog.validate();
    }

    public void requestFocus() {
        this.m_internalDialog.requestFocus();
    }

    public final Dimension getSize() {
        return this.m_internalDialog.getSize();
    }

    public final Dimension getPreferredSize() {
        return this.m_internalDialog.getPreferredSize();
    }

    public final void setSize(int a_width, int a_height) {
        this.m_internalDialog.setSize(a_width, a_height);
    }

    public final void setLocation(Point a_location) {
        this.m_bLocationSetManually = true;
        this.m_internalDialog.setLocation(a_location);
    }

    public final Rectangle getScreenBounds() {
        return GUIUtils.getCurrentScreen(this.m_internalDialog).getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDockable(boolean a_bDockable) {
        Object object = this.SYNC_DOCK;
        synchronized (object) {
            if (this.m_docker == null && a_bDockable) {
                this.m_docker = new GUIUtils.WindowDocker(this.m_internalDialog);
            } else if (this.m_docker != null && !a_bDockable) {
                this.m_docker.finalize();
                this.m_docker = null;
            }
        }
    }

    public void resetAutomaticLocation(boolean a_bDoNotSetLocationAutomatically) {
        this.m_bLocationSetManually = a_bDoNotSetLocationAutomatically;
    }

    public final void setLocationCenteredOnScreen() {
        this.m_bLocationSetManually = true;
        GUIUtils.centerOnScreen(this.m_internalDialog);
    }

    public final void setLocationRelativeTo(Component a_component, int a_position) {
        this.m_bLocationSetManually = true;
        GUIUtils.setLocationRelativeTo(a_component, this.m_internalDialog, a_position);
    }

    public void restoreLocation(Point a_point) {
        if (GUIUtils.restoreLocation(this.m_internalDialog, a_point)) {
            this.m_bLocationSetManually = true;
        }
    }

    public void restoreSize(Dimension a_size) {
        GUIUtils.restoreSize(this.m_internalDialog, a_size);
    }

    public void moveToUpRightCorner() {
        GUIUtils.moveToUpRightCorner(this.m_internalDialog);
    }

    public final void setLocation(int x, int y) {
        this.m_bLocationSetManually = true;
        this.m_internalDialog.setLocation(x, y);
    }

    public final void setSize(Dimension a_size) {
        this.m_internalDialog.setSize(a_size);
    }

    public void setResizable(boolean a_bResizable) {
        this.m_internalDialog.setResizable(a_bResizable);
    }

    public final Point getLocation() {
        return this.m_internalDialog.getLocation();
    }

    public boolean imageUpdate(Image a_image, int a_infoflags, int a_x, int a_y, int a_width, int a_height) {
        return this.m_internalDialog.imageUpdate(a_image, a_infoflags, a_x, a_y, a_width, a_height);
    }

    public final AccessibleContext getAccessibleContext() {
        return this.m_internalDialog.getAccessibleContext();
    }

    public Font getFont() {
        return this.m_internalDialog.getFont();
    }

    public void remove(MenuComponent a_component) {
        this.m_internalDialog.remove(a_component);
    }

    public boolean postEvent(Event a_event) {
        return this.m_internalDialog.postEvent(a_event);
    }

    public final void setDefaultCloseOperation(int a_windowAction) {
        this.m_defaultCloseOperation = a_windowAction;
    }

    public final int getDefaultCloseOperation() {
        return this.m_defaultCloseOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addWindowListener(WindowListener a_listener) {
        if (a_listener != null) {
            Object object = this.m_internalDialog.getTreeLock();
            synchronized (object) {
                this.m_windowListeners.addElement(a_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addComponentListener(ComponentListener a_listener) {
        Object object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            if (a_listener != null && !this.m_componentListeners.contains(a_listener)) {
                this.m_componentListeners.addElement(a_listener);
                this.m_internalDialog.addComponentListener(a_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeComponentListener(ComponentListener a_listener) {
        Object object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            this.m_componentListeners.removeElement(a_listener);
            this.m_internalDialog.removeComponentListener(a_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeWindowListener(WindowListener a_listener) {
        Object object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            this.m_windowListeners.removeElement(a_listener);
        }
    }

    public final void pack() {
        this.m_internalDialog.pack();
    }

    public Insets getInsets() {
        return this.m_internalDialog.getInsets();
    }

    void doWindowClosing() {
        this.m_dialogWindowAdapter.windowClosing(new WindowEvent(this.m_internalDialog, 201));
    }

    private static Window getInternalDialog(JAPDialog a_dialog) {
        if (a_dialog == null) {
            return null;
        }
        return a_dialog.m_internalDialog;
    }

    private static boolean requestFocusForFirstFocusableComponent(Container a_container) {
        try {
            (class$java$awt$Container == null ? (class$java$awt$Container = JAPDialog.class$("java.awt.Container")) : class$java$awt$Container).getMethod("isFocusable", null).invoke((Object)a_container, null);
            return true;
        }
        catch (Exception exception) {
            for (int i = 0; i < a_container.getComponentCount(); ++i) {
                if (a_container.getComponent(i) instanceof Container && JAPDialog.requestFocusForFirstFocusableComponent((Container)a_container.getComponent(i))) {
                    return true;
                }
                if (!a_container.getComponent(i).isFocusTraversable()) continue;
                a_container.getComponent(i).requestFocus();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisibleInternal(boolean a_bVisible) {
        if (this.isVisible() && this.m_bBlockParentWindow && !a_bVisible) {
            this.m_parentWindow.setEnabled(true);
            if (this.m_parentWindow.isVisible()) {
                this.m_parentWindow.setVisible(true);
            }
        }
        boolean bl = this.m_bBlockParentWindow = a_bVisible && this.m_bModal;
        if (this.m_bBlockParentWindow) {
            this.m_parentWindow.setEnabled(false);
        }
        if (this.m_bForceApplicationModality) {
            this.m_internalDialog.setVisible(a_bVisible);
            return;
        }
        Object object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            this.m_internalDialog.setVisible(a_bVisible);
            if (a_bVisible) {
                if (this.getContentPane() != null && this.getContentPane().isVisible()) {
                    this.getContentPane().setVisible(false);
                    this.getContentPane().setVisible(true);
                }
                this.m_internalDialog.toFront();
            }
            this.m_internalDialog.getTreeLock().notifyAll();
        }
        if (a_bVisible) {
            JAPDialog.requestFocusForFirstFocusableComponent(this.m_internalDialog.getContentPane());
            JButton bttnDefault = this.m_internalDialog.getRootPane().getDefaultButton();
            if (bttnDefault != null) {
                bttnDefault.requestFocus();
            }
        }
        if (this.m_bBlockParentWindow) {
            Runnable dialogThread = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        BlockedWindowDeactivationAdapter windowDeactivationAdapter = new BlockedWindowDeactivationAdapter();
                        JAPDialog.this.m_parentWindow.addWindowListener(windowDeactivationAdapter);
                        JAPDialog.this.m_parentWindow.addFocusListener(windowDeactivationAdapter);
                        if (SwingUtilities.isEventDispatchThread()) {
                            EventQueue theQueue = JAPDialog.this.m_internalDialog.getToolkit().getSystemEventQueue();
                            while (JAPDialog.this.isVisible()) {
                                Class<?> classActiveEvent;
                                AWTEvent event = theQueue.getNextEvent();
                                if (JAPDialog.this.m_bBlockParentWindow && JAPDialog.this.m_parentWindow.isEnabled()) {
                                    JAPDialog.this.m_parentWindow.setEnabled(false);
                                }
                                try {
                                    classActiveEvent = Class.forName("java.awt.ActiveEvent");
                                }
                                catch (ClassNotFoundException a_e) {
                                    classActiveEvent = null;
                                }
                                Object src = event.getSource();
                                if (src == JAPDialog.this.m_internalDialog) {
                                    if (event instanceof WindowEvent) {
                                        if (((WindowEvent)event).getID() == 201) {
                                            JAPDialog.this.m_dialogWindowAdapter.windowClosing((WindowEvent)event);
                                            continue;
                                        }
                                    } else if (!(event instanceof KeyEvent) || JAPDialog.this.getRootPane().getDefaultButton() != null) {
                                        // empty if block
                                    }
                                }
                                if (classActiveEvent != null && classActiveEvent.isInstance(event)) {
                                    classActiveEvent.getMethod("dispatch", null).invoke((Object)event, null);
                                    continue;
                                }
                                if (src instanceof Component) {
                                    if (src == JAPDialog.this.getParentComponent() && event instanceof WindowEvent && ((WindowEvent)event).getID() == 201) continue;
                                    try {
                                        ((Component)src).dispatchEvent(event);
                                    }
                                    catch (IllegalMonitorStateException a_e) {
                                        LogHolder.log(5, LogType.GUI, a_e);
                                    }
                                    continue;
                                }
                                if (!(src instanceof MenuComponent)) continue;
                                ((MenuComponent)src).dispatchEvent(event);
                            }
                        } else {
                            Object object = JAPDialog.this.m_internalDialog.getTreeLock();
                            synchronized (object) {
                                while (JAPDialog.this.isVisible()) {
                                    try {
                                        JAPDialog.this.m_internalDialog.getTreeLock().wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                        break;
                                    }
                                }
                                JAPDialog.this.m_internalDialog.getTreeLock().notifyAll();
                            }
                        }
                        JAPDialog.this.m_parentWindow.removeWindowListener(windowDeactivationAdapter);
                        JAPDialog.this.m_parentWindow.removeFocusListener(windowDeactivationAdapter);
                    }
                    catch (Exception a_e) {
                        LogHolder.log(2, LogType.GUI, a_e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                dialogThread.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(dialogThread);
                }
                catch (InterruptedException a_e) {
                    this.setVisible(false);
                }
                catch (Exception a_e) {
                    LogHolder.log(2, LogType.GUI, a_e);
                }
            }
            if (!this.m_parentWindow.isEnabled()) {
                this.m_bBlockParentWindow = false;
                this.m_parentWindow.setEnabled(!ms_bConsoleOnly);
                if (this.m_parentWindow.isVisible()) {
                    this.m_parentWindow.setVisible(true);
                }
            }
            if (ms_bConsoleOnly) {
                this.m_parentWindow.setEnabled(false);
            }
        }
        object = this.m_internalDialog.getTreeLock();
        synchronized (object) {
            this.m_internalDialog.getTreeLock().notifyAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FORMATS = new double[]{(1.0 + Math.sqrt(5.0)) / 2.0, 1.3333333333333333, 1.7777777777777777};
        MSG_ERROR_UNKNOWN = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_errorUnknown";
        MSG_TITLE_INFO = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_titleInfo";
        MSG_TITLE_CONFIRMATION = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_titleConfirmation";
        MSG_TITLE_WARNING = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_titleWarning";
        MSG_TITLE_ERROR = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_titleError";
        MSG_ERROR_UNDISPLAYABLE = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_errorUndisplayable";
        MSG_BTN_PROCEED = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_proceed";
        MSG_BTN_RETRY = (class$gui$dialog$JAPDialog == null ? (class$gui$dialog$JAPDialog = JAPDialog.class$("gui.dialog.JAPDialog")) : class$gui$dialog$JAPDialog).getName() + "_retry";
        m_optimizedFormat = 2;
        ms_registeredDialogs = new Hashtable();
        ms_bConsoleOnly = false;
    }

    private class BlockedWindowDeactivationAdapter
    extends WindowAdapter
    implements FocusListener {
        private BlockedWindowDeactivationAdapter() {
        }

        public void windowActivated(WindowEvent a_event) {
            this.deactivate(a_event.getWindow());
        }

        public void focusGained(FocusEvent a_event) {
            this.deactivate((Window)a_event.getComponent());
        }

        public void focusLost(FocusEvent a_event) {
        }

        private void deactivate(Window a_window) {
            if (JAPDialog.this.m_bBlockParentWindow) {
                JAPDialog.this.toFront();
                if (a_window.isEnabled()) {
                    a_window.setEnabled(false);
                }
            }
        }
    }

    private static class PreferredWidthBoxPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int m_preferredWidth = 0;
        private int m_preferredHeigth = 0;

        public PreferredWidthBoxPanel() {
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
        }

        public void setPreferredWidth(int a_preferredWidth) {
            this.m_preferredHeigth = 0;
            this.m_preferredWidth = a_preferredWidth;
        }

        public void setPreferredHeigth(int a_preferredHeigth) {
            this.m_preferredHeigth = a_preferredHeigth;
            this.m_preferredWidth = 0;
        }

        public Dimension getPreferredSize() {
            if (this.m_preferredWidth <= 0 && this.m_preferredHeigth <= 0) {
                return super.getPreferredSize();
            }
            if (this.m_preferredWidth > 0) {
                return new Dimension(this.m_preferredWidth, super.getPreferredSize().height);
            }
            return new Dimension(super.getPreferredSize().width, this.m_preferredHeigth);
        }
    }

    private static class LinkedInformationClickListener
    extends MouseAdapter
    implements ItemListener {
        private ILinkedInformation m_linkedInformation;

        public LinkedInformationClickListener(ILinkedInformation a_linkedInformation) {
            this.m_linkedInformation = a_linkedInformation;
        }

        public void mouseClicked(MouseEvent a_event) {
            this.m_linkedInformation.clicked(false);
        }

        public void itemStateChanged(ItemEvent a_event) {
            this.m_linkedInformation.clicked(((JCheckBox)a_event.getSource()).isSelected());
        }
    }

    private static class SimpleDialogButtonFocusWindowAdapter
    extends WindowAdapter {
        private DialogContentPane m_contentPane;

        public SimpleDialogButtonFocusWindowAdapter(DialogContentPane a_contentPane) {
            this.m_contentPane = a_contentPane;
        }

        public void windowOpened(WindowEvent a_event) {
            if (this.m_contentPane.getButtonCancel() != null) {
                this.m_contentPane.getButtonCancel().requestFocus();
            } else if (this.m_contentPane.getButtonNo() != null) {
                this.m_contentPane.getButtonNo().requestFocus();
            } else if (this.m_contentPane.getButtonYesOK() != null) {
                this.m_contentPane.getButtonYesOK().requestFocus();
            } else if (this.m_contentPane.getButtonHelp() != null) {
                this.m_contentPane.getButtonHelp().requestFocus();
            }
        }
    }

    private class DialogWindowAdapter
    implements WindowListener {
        private DialogWindowAdapter() {
        }

        public void windowOpened(WindowEvent a_event) {
            Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((WindowListener)listeners.elementAt(i)).windowOpened(a_event);
            }
        }

        public void windowIconified(WindowEvent a_event) {
            Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((WindowListener)listeners.elementAt(i)).windowIconified(a_event);
            }
        }

        public void windowDeiconified(WindowEvent a_event) {
            Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((WindowListener)listeners.elementAt(i)).windowDeiconified(a_event);
            }
        }

        public void windowDeactivated(WindowEvent a_event) {
            Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((WindowListener)listeners.elementAt(i)).windowDeactivated(a_event);
            }
        }

        public void windowActivated(WindowEvent a_event) {
            Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((WindowListener)listeners.elementAt(i)).windowActivated(a_event);
            }
        }

        public void windowClosed(WindowEvent a_event) {
        }

        public void windowClosing(WindowEvent a_event) {
            if (JAPDialog.this.isEnabled()) {
                if (JAPDialog.this.getDefaultCloseOperation() == 2) {
                    try {
                        JAPDialog.this.dispose();
                    }
                    catch (IllegalMonitorStateException a_e) {
                        LogHolder.log(7, LogType.GUI, a_e);
                    }
                } else if (JAPDialog.this.getDefaultCloseOperation() == 1) {
                    JAPDialog.this.setVisible(false);
                } else if (!JAPDialog.this.isVisible()) {
                    JAPDialog.this.m_internalDialog.setVisible(true);
                    LogHolder.log(6, LogType.GUI, "Fixed old JRE dialog closing bug.");
                }
                Vector listeners = (Vector)JAPDialog.this.m_windowListeners.clone();
                for (int i = 0; i < listeners.size(); ++i) {
                    ((WindowListener)listeners.elementAt(i)).windowClosing(a_event);
                }
            }
        }
    }

    public static class Options {
        private int m_optionType;
        private DialogContentPaneOptions.OptionsUpdateCallback m_callbackOptions;
        private DialogContentPaneOptions.IOptionsUpdateCallbackHandler m_callbackHandlerOptions;

        public Options(int a_optionType) {
            this.m_optionType = a_optionType;
            this.m_callbackHandlerOptions = new DialogContentPaneOptions.IOptionsUpdateCallbackHandler(){

                public void setUpdateCallback(DialogContentPaneOptions.OptionsUpdateCallback a_callback) {
                    Options.this.m_callbackOptions = a_callback;
                }
            };
        }

        private DialogContentPaneOptions.IOptionsUpdateCallbackHandler getUpdateCallbackHandler() {
            return this.m_callbackHandlerOptions;
        }

        public void update() {
            if (this.m_callbackOptions != null) {
                this.m_callbackOptions.update();
            }
        }

        public final int getOptionType() {
            return this.m_optionType;
        }

        public int getDefaultButton() {
            if (this.m_optionType == -2147483647 || this.m_optionType == 2 || this.m_optionType == 1) {
                return 1;
            }
            if (this.m_optionType == 0) {
                return 3;
            }
            return -1;
        }

        public boolean isDrawFocusEnabled() {
            return true;
        }

        public String getYesOKText() {
            return null;
        }

        public String getNoText() {
            return null;
        }

        public String getCancelText() {
            return null;
        }
    }

    public static class LinkedHelpContext
    extends LinkedInformationAdapter
    implements JAPHelpContext.IHelpContext {
        private JAPHelpContext.IHelpContext m_helpContext;

        public LinkedHelpContext(JAPHelpContext.IHelpContext a_helpContext) {
            this.m_helpContext = a_helpContext;
        }

        public LinkedHelpContext(final String a_strHelpContext) {
            this.m_helpContext = new JAPHelpContext.IHelpContext(){

                public String getHelpContext() {
                    return a_strHelpContext;
                }

                public Component getHelpExtractionDisplayContext() {
                    return null;
                }
            };
        }

        public final String getHelpContext() {
            if (this.m_helpContext == null) {
                return null;
            }
            return this.m_helpContext.getHelpContext();
        }

        public Component getHelpExtractionDisplayContext() {
            if (this.m_helpContext == null) {
                return null;
            }
            return this.m_helpContext.getHelpExtractionDisplayContext();
        }

        public String getMessage() {
            return null;
        }

        public void clicked(boolean a_bState) {
        }

        public int getType() {
            return 0;
        }

        public final boolean isApplicationModalityForced() {
            return false;
        }
    }

    public static abstract class AbstractLinkedURLAdapter
    extends LinkedHelpContext {
        public static final String MAILTO = "mailto:";

        public AbstractLinkedURLAdapter(String a_strHelpContext) {
            super(a_strHelpContext);
        }

        public AbstractLinkedURLAdapter() {
            super((String)null);
        }

        public abstract URL getUrl();

        public String getTooltipText() {
            URL url = this.getUrl();
            if (url != null) {
                String strMsg = this.getUrl().toString();
                if (strMsg.toLowerCase().startsWith(MAILTO) && strMsg.length() > MAILTO.length()) {
                    strMsg = strMsg.substring(MAILTO.length(), strMsg.length());
                }
                return strMsg;
            }
            return null;
        }

        public String getMessage() {
            return this.getTooltipText();
        }

        public void clicked(boolean a_bState) {
            if (this.getUrl() != null) {
                AbstractOS.getInstance().openURL(this.getUrl());
            }
        }

        public final int getType() {
            return 1;
        }
    }

    public static class LinkedInformationAdapter
    implements ILinkedInformation {
        public String getTooltipText() {
            return null;
        }

        public String getMessage() {
            return null;
        }

        public void clicked(boolean a_bState) {
        }

        public int getType() {
            return 0;
        }

        public boolean isApplicationModalityForced() {
            return false;
        }

        public boolean isOnTop() {
            return false;
        }

        public boolean isModal() {
            return true;
        }

        public boolean isCloseWindowActive() {
            return true;
        }
    }

    public static class LinkedInformation
    extends LinkedInformationAdapter {
        private String m_message;
        private String m_eMail;
        private URL m_url;

        public LinkedInformation(String a_link) {
            this(a_link, null);
        }

        public LinkedInformation(String a_link, String a_message) {
            this.m_message = a_message;
            if (AbstractX509AlternativeName.isValidEMail(a_link)) {
                this.m_eMail = a_link;
                if (this.m_message == null) {
                    this.m_message = this.m_eMail;
                }
            } else {
                try {
                    this.m_url = new URL(a_link);
                    if (this.m_message == null) {
                        this.m_message = this.m_url.toString();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        public final int getType() {
            return 1;
        }

        public final void clicked(boolean a_bState) {
            if (this.m_eMail != null) {
                AbstractOS.getInstance().openEMail(this.m_eMail);
            } else if (this.m_url != null) {
                AbstractOS.getInstance().openURL(this.m_url);
            }
        }

        public final String getMessage() {
            return this.m_message;
        }
    }

    public static class LinkedCheckBox
    extends LinkedHelpContext {
        public static final String MSG_REMEMBER_ANSWER = (class$gui$dialog$JAPDialog$LinkedCheckBox == null ? (class$gui$dialog$JAPDialog$LinkedCheckBox = JAPDialog.class$("gui.dialog.JAPDialog$LinkedCheckBox")) : class$gui$dialog$JAPDialog$LinkedCheckBox).getName() + "_rememberAnswer";
        public static final String MSG_DO_NOT_SHOW_AGAIN = (class$gui$dialog$JAPDialog$LinkedCheckBox == null ? (class$gui$dialog$JAPDialog$LinkedCheckBox = JAPDialog.class$("gui.dialog.JAPDialog$LinkedCheckBox")) : class$gui$dialog$JAPDialog$LinkedCheckBox).getName() + "_doNotShowAgain";
        private String m_strMessage;
        private boolean m_bDefault;
        private boolean m_bState;

        public LinkedCheckBox(boolean a_bDefault) {
            this(a_bDefault, (JAPHelpContext.IHelpContext)null);
        }

        public LinkedCheckBox(boolean a_bDefault, JAPHelpContext.IHelpContext a_helpContext) {
            this(JAPMessages.getString(MSG_DO_NOT_SHOW_AGAIN), a_bDefault, a_helpContext);
        }

        public LinkedCheckBox(boolean a_bDefault, String a_strHelpContext) {
            this(JAPMessages.getString(MSG_DO_NOT_SHOW_AGAIN), a_bDefault, a_strHelpContext);
        }

        public LinkedCheckBox(String a_strMessage, boolean a_bDefault) {
            this(a_strMessage, a_bDefault, (JAPHelpContext.IHelpContext)null);
        }

        public LinkedCheckBox(String a_strMessage, boolean a_bDefault, final String a_strHelpContext) {
            this(a_strMessage, a_bDefault, new JAPHelpContext.IHelpContext(){

                public String getHelpContext() {
                    return a_strHelpContext;
                }

                public Component getHelpExtractionDisplayContext() {
                    return null;
                }
            });
        }

        public LinkedCheckBox(String a_strMessage, boolean a_bDefault, JAPHelpContext.IHelpContext a_helpContext) {
            super(a_helpContext);
            this.m_strMessage = a_strMessage;
            this.m_bState = this.m_bDefault = a_bDefault;
        }

        public String getMessage() {
            return this.m_strMessage;
        }

        public void clicked(boolean a_bState) {
            this.m_bState = a_bState;
        }

        public final boolean getState() {
            return this.m_bState;
        }

        public final int getType() {
            if (this.m_bDefault) {
                return 3;
            }
            return 4;
        }
    }

    public static class LinkedURLCheckBox
    extends LinkedCheckBox
    implements JAPHelpContext.IURLHelpContext {
        private URL m_url;
        private String m_message;

        public LinkedURLCheckBox(boolean a_bDefault, final URL a_url, final String a_message) {
            super(a_bDefault, new JAPHelpContext.IURLHelpContext(){

                public String getURLMessage() {
                    return a_message;
                }

                public URL getHelpURL() {
                    return a_url;
                }

                public String getHelpContext() {
                    return a_url.toString();
                }

                public Component getHelpExtractionDisplayContext() {
                    return null;
                }
            });
            if (a_url == null) {
                throw new NullPointerException("URL is null!");
            }
            if (a_message == null) {
                throw new NullPointerException("URL message is null!");
            }
            this.m_url = a_url;
            this.m_message = a_message;
        }

        public String getURLMessage() {
            return this.m_message;
        }

        public URL getHelpURL() {
            return this.m_url;
        }
    }

    public static interface ILinkedInformation {
        public static final String MSG_MORE_INFO = (class$gui$dialog$JAPDialog$ILinkedInformation == null ? (class$gui$dialog$JAPDialog$ILinkedInformation = JAPDialog.class$("gui.dialog.JAPDialog$ILinkedInformation")) : class$gui$dialog$JAPDialog$ILinkedInformation).getName() + "_moreInfo";
        public static final int TYPE_DEFAULT = 0;
        public static final int TYPE_LINK = 1;
        public static final int TYPE_SELECTABLE_LINK = 2;
        public static final int TYPE_CHECKBOX_TRUE = 3;
        public static final int TYPE_CHECKBOX_FALSE = 4;

        public String getMessage();

        public void clicked(boolean var1);

        public int getType();

        public boolean isApplicationModalityForced();

        public boolean isOnTop();

        public boolean isModal();

        public boolean isCloseWindowActive();

        public String getTooltipText();
    }
}

