/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationInfo;
import HTTPClient.GlobalConstants;
import HTTPClient.NVPair;
import HTTPClient.SocksException;
import HTTPClient.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SocksClient
implements GlobalConstants {
    private String socks_host;
    private int socks_port;
    private int socks_version;
    private static final byte CONNECT = 1;
    private static final byte BIND = 2;
    private static final byte UDP_ASS = 3;
    private static final byte NO_AUTH = 0;
    private static final byte GSSAPI = 1;
    private static final byte USERPWD = 2;
    private static final byte NO_ACC = -1;
    private static final byte IP_V4 = 1;
    private static final byte DMNAME = 3;
    private static final byte IP_V6 = 4;
    private boolean v4A = false;
    private byte[] user = null;

    public SocksClient(String host, int port) {
        this.socks_host = host;
        this.socks_port = port;
        this.socks_version = -1;
    }

    SocksClient(String host, int port, int version) throws SocksException {
        this.socks_host = host;
        this.socks_port = port;
        if (version != 4 && version != 5) {
            throw new SocksException("SOCKS Version not supported: " + version);
        }
        this.socks_version = version;
    }

    public Socket getSocket(String host, int port) throws IOException {
        Socket sock = null;
        try {
            if (GlobalConstants.DebugSocks) {
                Util.logLine("Socks: contacting server on " + this.socks_host + ":" + this.socks_port);
            }
            sock = SocksClient.connect(this.socks_host, this.socks_port);
            InputStream inp = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            switch (this.socks_version) {
                case 4: {
                    this.v4ProtExchg(inp, out, host, port);
                    break;
                }
                case 5: {
                    this.v5ProtExchg(inp, out, host, port);
                    break;
                }
                case -1: {
                    try {
                        this.v4ProtExchg(inp, out, host, port);
                        this.socks_version = 4;
                    }
                    catch (SocksException se) {
                        if (GlobalConstants.DebugSocks) {
                            Util.logLine("Socks: V4 request failed: " + se.getMessage());
                        }
                        sock.close();
                        sock = SocksClient.connect(this.socks_host, this.socks_port);
                        inp = sock.getInputStream();
                        out = sock.getOutputStream();
                        this.v5ProtExchg(inp, out, host, port);
                        this.socks_version = 5;
                    }
                    break;
                }
                default: {
                    throw new Error("SocksClient internal error: unknown version " + this.socks_version);
                }
            }
            if (GlobalConstants.DebugSocks) {
                Util.logLine("Socks: connection established.");
            }
            return sock;
        }
        catch (IOException ioe) {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    private static final Socket connect(String host, int port) throws IOException {
        InetAddress[] addr_list = InetAddress.getAllByName(host);
        int idx = 0;
        while (idx < addr_list.length) {
            try {
                return new Socket(addr_list[idx], port);
            }
            catch (SocketException se) {
                if (idx >= addr_list.length - 1) {
                    throw se;
                }
                ++idx;
            }
        }
        return null;
    }

    private void v4ProtExchg(InputStream inp, OutputStream out, String host, int port) throws SocksException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Beginning V4 Protocol Exchange for host " + host + ":" + port);
        }
        byte[] addr = new byte[]{0, 0, 0, 42};
        if (!this.v4A) {
            try {
                addr = InetAddress.getByName(host).getAddress();
            }
            catch (UnknownHostException uhe) {
                this.v4A = true;
            }
            catch (SecurityException se) {
                this.v4A = true;
            }
            if (GlobalConstants.DebugSocks && this.v4A) {
                Util.logLine("Socks: Switching to version 4A");
            }
        }
        if (this.user == null) {
            String user_str;
            try {
                user_str = System.getProperty("user.name", "");
            }
            catch (SecurityException se) {
                user_str = "";
            }
            this.user = new byte[user_str.length() + 1];
            System.arraycopy(user_str.getBytes(), 0, this.user, 0, user_str.length());
            this.user[user_str.length()] = 0;
        }
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Sending connect request for user " + new String(this.user));
        }
        buffer.reset();
        buffer.write(4);
        buffer.write(1);
        buffer.write(port >> 8 & 0xFF);
        buffer.write(port & 0xFF);
        buffer.write(addr, 0, addr.length);
        buffer.write(this.user, 0, this.user.length);
        if (this.v4A) {
            byte[] host_buf = host.getBytes();
            buffer.write(host_buf, 0, host_buf.length);
            buffer.write(0);
        }
        buffer.writeTo(out);
        int version = inp.read();
        if (version == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (version == 4) {
            if (GlobalConstants.DebugSocks) {
                Util.logLine("Socks: Warning: received version 4 instead of 0");
            } else if (version != 0) {
                throw new SocksException("Received invalid version: " + version + "; expected: 0");
            }
        }
        int sts = inp.read();
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Received response; version: " + version + "; status: " + sts);
        }
        switch (sts) {
            case 90: {
                break;
            }
            case 91: {
                throw new SocksException("Connection request rejected");
            }
            case 92: {
                throw new SocksException("Connection request rejected: can't connect to identd");
            }
            case 93: {
                throw new SocksException("Connection request rejected: identd reports different user-id from " + new String(this.user));
            }
            default: {
                throw new SocksException("Connection request rejected: unknown error " + sts);
            }
        }
        byte[] skip = new byte[6];
        int rcvd = 0;
        int tot = 0;
        while (tot < skip.length && (rcvd = inp.read(skip, 0, skip.length - tot)) != -1) {
            tot += rcvd;
        }
    }

    private void v5ProtExchg(InputStream inp, OutputStream out, String host, int port) throws SocksException, IOException {
        int alen;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Beginning V5 Protocol Exchange for host " + host + ":" + port);
        }
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Sending authentication request; methods No-Authentication, Username/Password");
        }
        buffer.reset();
        buffer.write(5);
        buffer.write(2);
        buffer.write(0);
        buffer.write(2);
        buffer.writeTo(out);
        int version = inp.read();
        if (version == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (version != 5) {
            throw new SocksException("Received invalid version: " + version + "; expected: 5");
        }
        int method = inp.read();
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Received response; version: " + version + "; method: " + method);
        }
        switch (method) {
            case 0: {
                break;
            }
            case 1: {
                this.negotiate_gssapi(inp, out);
                break;
            }
            case 2: {
                this.negotiate_userpwd(inp, out);
                break;
            }
            case -1: {
                throw new SocksException("Server unwilling to accept any standard authentication methods");
            }
            default: {
                throw new SocksException("Cannot handle authentication method " + method);
            }
        }
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Sending connect request");
        }
        buffer.reset();
        buffer.write(5);
        buffer.write(1);
        buffer.write(0);
        buffer.write(3);
        buffer.write(host.length() & 0xFF);
        byte[] hname = host.getBytes();
        buffer.write(hname, 0, hname.length);
        buffer.write(port >> 8 & 0xFF);
        buffer.write(port & 0xFF);
        buffer.writeTo(out);
        version = inp.read();
        if (version != 5) {
            throw new SocksException("Received invalid version: " + version + "; expected: 5");
        }
        int sts = inp.read();
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Received response; version: " + version + "; status: " + sts);
        }
        switch (sts) {
            case 0: {
                break;
            }
            case 1: {
                throw new SocksException("General SOCKS server failure");
            }
            case 2: {
                throw new SocksException("Connection not allowed");
            }
            case 3: {
                throw new SocksException("Network unreachable");
            }
            case 4: {
                throw new SocksException("Host unreachable");
            }
            case 5: {
                throw new SocksException("Connection refused");
            }
            case 6: {
                throw new SocksException("TTL expired");
            }
            case 7: {
                throw new SocksException("Command not supported");
            }
            case 8: {
                throw new SocksException("Address type not supported");
            }
            default: {
                throw new SocksException("Unknown reply received from server: " + sts);
            }
        }
        inp.read();
        int atype = inp.read();
        switch (atype) {
            case 4: {
                alen = 16;
                break;
            }
            case 1: {
                alen = 4;
                break;
            }
            case 3: {
                alen = inp.read();
                break;
            }
            default: {
                throw new SocksException("Invalid address type received from server: " + atype);
            }
        }
        byte[] skip = new byte[alen + 2];
        int rcvd = 0;
        int tot = 0;
        while (tot < skip.length && (rcvd = inp.read(skip, 0, skip.length - tot)) != -1) {
            tot += rcvd;
        }
    }

    private void negotiate_gssapi(InputStream inp, OutputStream out) throws SocksException, IOException {
        throw new SocksException("GSSAPI authentication protocol not implemented");
    }

    private void negotiate_userpwd(InputStream inp, OutputStream out) throws SocksException, IOException {
        AuthorizationInfo auth_info;
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Entering authorization subnegotiation; method: Username/Password");
        }
        try {
            auth_info = AuthorizationInfo.getAuthorization(this.socks_host, this.socks_port, "SOCKS5", "USER/PASS", false, true);
        }
        catch (AuthSchemeNotImplException atnie) {
            auth_info = null;
        }
        if (auth_info == null) {
            throw new SocksException("No Authorization info for SOCKS found (server requested username/password).");
        }
        NVPair[] unpw = auth_info.getParams();
        if (unpw == null || unpw.length == 0) {
            throw new SocksException("No Username/Password found in authorization info for SOCKS.");
        }
        String user_str = unpw[0].getName();
        String pass_str = unpw[0].getValue();
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Sending authorization request for user " + user_str);
        }
        byte[] buffer = new byte[2 + user_str.length() + 1 + pass_str.length()];
        buffer[0] = 1;
        buffer[1] = (byte)user_str.length();
        Util.getBytes(user_str, buffer[1], buffer, 2);
        buffer[2 + buffer[1]] = (byte)pass_str.length();
        Util.getBytes(pass_str, buffer[2 + buffer[1]], buffer, 2 + buffer[1] + 1);
        out.write(buffer);
        int version = inp.read();
        if (version != 1) {
            throw new SocksException("Wrong version received in username/password subnegotiation response: " + version + "; expected: 1");
        }
        int sts = inp.read();
        if (sts != 0) {
            throw new SocksException("Username/Password authentication failed; status: " + sts);
        }
        if (GlobalConstants.DebugSocks) {
            Util.logLine("Socks: Received response; version: " + version + "; status: " + sts);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.socks_host + ":" + this.socks_port + "]";
    }
}

