/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPrivateKey;
import anon.crypto.MyECPrivateKey;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

public class ECKeyPair
extends AsymmetricCryptoKeyPair {
    ECKeyPair(IMyPrivateKey a_privateKey) {
        super(a_privateKey);
    }

    public static ECKeyPair getInstance(SecureRandom a_secureRandom) {
        return ECKeyPair.getInstance(SECObjectIdentifiers.secp160r1, a_secureRandom);
    }

    public static ECKeyPair getInstance(ASN1ObjectIdentifier a_namedCurve, SecureRandom a_secureRandom) {
        ECKeyPair keyPair;
        X9ECParameters x9params = SECNamedCurves.getByOID(a_namedCurve);
        if (x9params == null) {
            x9params = X962NamedCurves.getByOID(a_namedCurve);
        }
        if (x9params == null) {
            x9params = NISTNamedCurves.getByOID(a_namedCurve);
        }
        if (x9params == null) {
            x9params = TeleTrusTNamedCurves.getByOID(a_namedCurve);
        }
        if (x9params == null) {
            throw new IllegalArgumentException("Unknown Named Curve Identifier!");
        }
        ECDomainParameters domainParameters = new ECDomainParameters(x9params.getCurve(), x9params.getG(), x9params.getN(), x9params.getH());
        ECKeyGenerationParameters keyGenParams = new ECKeyGenerationParameters(domainParameters, a_secureRandom);
        ECKeyPairGenerator keyPairGen = new ECKeyPairGenerator();
        keyPairGen.init(keyGenParams);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGen.generateKeyPair();
        try {
            keyPair = new ECKeyPair(new MyECPrivateKey((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), a_namedCurve));
        }
        catch (Exception e) {
            return null;
        }
        if (!AsymmetricCryptoKeyPair.isValidKeyPair(keyPair)) {
            return null;
        }
        return keyPair;
    }
}

