/*
 * Decompiled with CFR 0.152.
 */
package anon.shared;

import anon.shared.AbstractChannel;
import java.io.IOException;
import java.io.OutputStream;

final class ChannelOutputStream
extends OutputStream {
    boolean m_bIsClosed = false;
    AbstractChannel m_channel = null;

    protected ChannelOutputStream(AbstractChannel c) {
        this.m_channel = c;
    }

    public void write(int i) throws IOException {
        if (this.m_bIsClosed) {
            throw new IOException("Channel closed by peer");
        }
        byte[] buff = new byte[]{(byte)i};
        this.m_channel.send(buff, 1);
    }

    public void write(byte[] buff, int start, int len) throws IOException {
        if (this.m_bIsClosed) {
            throw new IOException("Channel closed by peer");
        }
        this.m_channel.send(buff, (short)len);
    }

    public void close() {
        this.m_bIsClosed = true;
    }

    void closedByPeer() {
        this.m_bIsClosed = true;
    }
}

