/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserContentPane
extends DialogContentPane
implements DialogContentPane.IWizardSuitable {
    public static final String MSG_CHOOSE_FILE = (class$gui$dialog$FileChooserContentPane == null ? (class$gui$dialog$FileChooserContentPane = FileChooserContentPane.class$("gui.dialog.FileChooserContentPane")) : class$gui$dialog$FileChooserContentPane).getName() + "_errorChooseFile";
    private static final String MSG_CHOOSE_DIR = (class$gui$dialog$FileChooserContentPane == null ? (class$gui$dialog$FileChooserContentPane = FileChooserContentPane.class$("gui.dialog.FileChooserContentPane")) : class$gui$dialog$FileChooserContentPane).getName() + "_errorChooseDirectory";
    private JTextField pathField;
    private JFileChooser chooser;
    private int m_fileSelectionMode;
    static /* synthetic */ Class class$gui$dialog$FileChooserContentPane;

    public FileChooserContentPane(JAPDialog dialog, String a_strText, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType) {
        this(dialog, a_strText, new DialogContentPane.Layout(""), a_defaultValue, fileSelectionMode, a_fileChooserDialogType, null, null);
    }

    public FileChooserContentPane(JAPDialog dialog, String a_strText, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType, FileFilter a_fileFilter) {
        this(dialog, a_strText, new DialogContentPane.Layout(""), a_defaultValue, fileSelectionMode, a_fileChooserDialogType, a_fileFilter, null);
    }

    public FileChooserContentPane(JAPDialog dialog, String a_strText, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType, DialogContentPane a_previousContentPane) {
        this(dialog, a_strText, new DialogContentPane.Layout(""), a_defaultValue, fileSelectionMode, a_fileChooserDialogType, null, a_previousContentPane);
    }

    public FileChooserContentPane(JAPDialog dialog, String a_strText, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType, FileFilter a_fileFilter, DialogContentPane a_previousContentPane) {
        this(dialog, a_strText, new DialogContentPane.Layout(""), a_defaultValue, fileSelectionMode, a_fileChooserDialogType, a_fileFilter, a_previousContentPane);
    }

    public FileChooserContentPane(JAPDialog dialog, String a_strText, DialogContentPane.Layout a_layout, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType) {
        this(dialog, a_strText, a_layout, a_defaultValue, fileSelectionMode, a_fileChooserDialogType, null, null);
    }

    public FileChooserContentPane(JAPDialog dialog, String a_strText, DialogContentPane.Layout a_layout, String a_defaultValue, int fileSelectionMode, String a_fileChooserDialogType, FileFilter a_fileFilter) {
        this(dialog, a_strText, a_layout, a_defaultValue, fileSelectionMode, a_fileChooserDialogType, a_fileFilter, null);
    }

    public FileChooserContentPane(final JAPDialog dialog, String a_strText, DialogContentPane.Layout a_layout, String a_defaultValue, int fileSelectionMode, final String a_fileChooserDialogType, FileFilter a_fileFilter, DialogContentPane a_previousContentPane) {
        super(dialog, a_strText, a_layout, new DialogContentPaneOptions(2, a_previousContentPane));
        JButton pathChooseButton = new JButton(JAPMessages.getString("bttnChoose"));
        this.pathField = new JTextField(15);
        this.pathField.setEditable(false);
        if (a_defaultValue != null) {
            this.pathField.setText(a_defaultValue);
        }
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(fileSelectionMode);
        if (a_fileFilter != null) {
            this.chooser.setFileFilter(a_fileFilter);
        }
        this.m_fileSelectionMode = this.chooser.getFileSelectionMode();
        this.getContentPane().add(this.pathField);
        this.getContentPane().add(pathChooseButton);
        ActionListener chooseListener = new ActionListener(){

            public void actionPerformed(ActionEvent aev) {
                File fileCurrent = FileChooserContentPane.this.getFile();
                if (fileCurrent != null && fileCurrent.isDirectory()) {
                    FileChooserContentPane.this.chooser.setCurrentDirectory(fileCurrent);
                }
                if (GUIUtils.showMonitoredFileChooser(FileChooserContentPane.this.chooser, dialog.getContentPane(), a_fileChooserDialogType) == 0) {
                    File f = FileChooserContentPane.this.chooser.getSelectedFile();
                    if (f != null) {
                        FileChooserContentPane.this.pathField.setText(f.getPath());
                    }
                    FileChooserContentPane.this.clearStatusMessage();
                }
            }
        };
        pathChooseButton.addActionListener(chooseListener);
    }

    public File getFile() {
        String strpath = this.pathField.getText();
        if (strpath != null) {
            strpath = strpath.trim();
        }
        if (strpath.length() > 0) {
            return new File(strpath);
        }
        return null;
    }

    public DialogContentPane.CheckError checkYesOK() {
        String strMessage = this.m_fileSelectionMode == 1 ? JAPMessages.getString(MSG_CHOOSE_DIR) : JAPMessages.getString(MSG_CHOOSE_FILE);
        File file = this.getFile();
        if (file == null || this.m_fileSelectionMode == 1 && !file.isDirectory() || this.m_fileSelectionMode == 0 && file.isDirectory()) {
            return new DialogContentPane.CheckError(strMessage);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

