/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.wizard;

import gui.JAPHelpContext;
import gui.dialog.JAPDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.panels.AdvancedPanel;
import mixconfig.panels.GeneralPanel;
import mixconfig.panels.MixConfigPanel;
import mixconfig.panels.NextMixProxyPanel;
import mixconfig.panels.OwnCertificatesPanel;
import mixconfig.panels.PaymentPanel;
import mixconfig.panels.PreviousMixPanel;
import mixconfig.panels.TermsAndConditionsPanel;
import mixconfig.panels.WizardFinishPanel;
import mixconfig.wizard.CannotContinueException;

public class ConfigWizardPanel
extends JPanel
implements ChangeListener,
JAPHelpContext.IHelpContext {
    public static final int STATE_GO = 0;
    public static final int STATE_BEGIN = 1;
    public static final int STATE_END = 2;
    public static final int STATE_STOP = 4;
    public static final int STATE_FINISHED = 11;
    public static final int STATE_READY_TO_FINISH = 2;
    private int m_currentPage = 0;
    private CardLayout m_layout = new CardLayout(4, 4);
    private MixConfigPanel[] m_pages;
    private Vector<ChangeListener> m_changeListener = new Vector();
    private int m_state = 1;
    private String[] m_errors = new String[0];

    public ConfigWizardPanel() throws IOException {
        this.setLayout(this.m_layout);
        this.setBorder(new EtchedBorder());
        this.m_pages = new MixConfigPanel[8];
        this.m_pages[0] = new GeneralPanel();
        this.m_pages[1] = new AdvancedPanel();
        this.m_pages[2] = new PaymentPanel();
        this.m_pages[3] = new OwnCertificatesPanel(false);
        this.m_pages[4] = new PreviousMixPanel();
        this.m_pages[5] = new NextMixProxyPanel();
        this.m_pages[6] = TermsAndConditionsPanel.get();
        this.m_pages[7] = new WizardFinishPanel();
        this.setConfiguration(null);
        for (int i = 0; i < this.m_pages.length; ++i) {
            this.add((Component)this.m_pages[i], this.m_pages[i].getClass().getName());
        }
        this.m_layout.first(this);
        this.m_state = 1;
    }

    public void checkAndForward() {
        this.checkState();
        if ((this.m_state & 2) != 0 || (this.m_state & 4) != 0) {
            throw new CannotContinueException(this.m_errors);
        }
        this.doForward();
    }

    public void doForward() {
        ++this.m_currentPage;
        this.m_layout.next(this);
        if (!this.m_pages[this.m_currentPage].isEnabled()) {
            this.checkAndForward();
        }
        this.fireStateChanged();
    }

    public void back() {
        this.checkState();
        if ((this.m_state & 1) != 0) {
            throw new CannotContinueException(this.m_errors);
        }
        --this.m_currentPage;
        this.m_layout.previous(this);
        if (!this.m_pages[this.m_currentPage].isEnabled()) {
            this.back();
        }
        this.fireStateChanged();
    }

    @Override
    public String getHelpContext() {
        return this.m_pages[this.m_currentPage].getHelpContext();
    }

    public Container getCurrentPage() {
        return this.m_pages[this.m_currentPage];
    }

    public int getState() {
        this.checkState();
        return this.m_state;
    }

    public void finish() {
        this.m_state = 1;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener cl) {
        this.m_changeListener.addElement(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.m_changeListener.removeElement(cl);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    public Vector<String> check() {
        Vector<String> errors = new Vector<String>();
        for (int i = 0; i < this.m_pages.length - 1; ++i) {
            if (!this.m_pages[i].isEnabled()) continue;
            Vector<String> temp = this.m_pages[i].check();
            for (int j = 0; j < temp.size(); ++j) {
                errors.addElement(temp.elementAt(j));
            }
        }
        return errors;
    }

    protected void fireStateChanged() {
        for (int i = 0; i < this.m_changeListener.size(); ++i) {
            this.m_changeListener.elementAt(i).stateChanged(new ChangeEvent(this));
        }
    }

    protected int getNewState() {
        int newstate = 0;
        this.m_errors = new String[0];
        if (this.m_currentPage == 0) {
            newstate |= 1;
        }
        Vector<String> errors = null;
        if (this.m_pages[this.m_currentPage].isEnabled()) {
            errors = this.m_pages[this.m_currentPage].check();
        }
        if (errors != null && errors.size() > 0) {
            newstate |= 4;
            this.m_errors = new String[errors.size()];
            for (int i = 0; i < this.m_errors.length; ++i) {
                this.m_errors[i] = errors.elementAt(i);
            }
        }
        if (this.m_currentPage == this.m_pages.length - 1) {
            newstate |= 2;
        }
        if (this.m_currentPage >= this.m_pages.length) {
            newstate |= 2;
        }
        return newstate;
    }

    protected void load() {
        try {
            for (int i = 0; i < this.m_pages.length; ++i) {
                LogHolder.log(7, LogType.MISC, "Loading component " + i);
                this.m_pages[i].load();
            }
        }
        catch (Exception io) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "Error on loading the MixConfiguration", (Throwable)io);
        }
        while (!this.m_pages[this.getCurrentPageNr()].isEnabled()) {
            this.back();
        }
    }

    protected void reset() {
        this.m_layout.first(this);
        this.m_state = 1;
        this.m_currentPage = 0;
    }

    private void checkState() {
        int oldstate = this.m_state;
        this.m_state = this.getNewState();
        if (oldstate != this.m_state) {
            this.fireStateChanged();
        }
    }

    protected void setConfiguration(MixConfiguration m) throws IOException {
        if (m == null) {
            m = MixConfig.getMixConfiguration();
        }
        for (int i = 0; i < this.m_pages.length - 1; ++i) {
            this.m_pages[i].setConfiguration(m);
        }
    }

    public int getCurrentPageNr() {
        return this.m_currentPage;
    }

    public int getPageCount() {
        return this.m_pages.length;
    }

    public MixConfigPanel getPage(int a_number) {
        return this.m_pages[a_number];
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

